@extends('app')
@section('title','List student')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
        .dataTables_length label, .select-info{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0">
                                    <h4>Student - [{{ $nombre <= 9 ? '0'.$nombre:$nombre }}]</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" data-toggle="modal" data-target="#upload" title="Import File"> <i class="fas fa-ellipsis-h m-0"></i></button>
                                        <a href="{{route('parent.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Parent List"> <i class="fab fa-cloudsmith m-0"></i></a>
                                        <a href="{{route('student.index1')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Disabled Student"> <i class="fas fa-underline m-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block my-0 pt-0">
                                <div class="row mt-0 pt-0 justify-content-end">
                                    @foreach ($statistics as $statistic)
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card my-0">
                                            <div class="card-footer py-0 pb-0">
                                                <div class="row align-items-center" title="{{ ucwords($statistic['libelle']) }}" style="background: #545557; color: white">
                                                    <div class="col-12 d-flex justify-content-between">
                                                        <span style="font-size: 17px; text-decoration: underline;">{{ substr(ucwords($statistic['libelle']), 0, 14) }} :</span>
                                                        <strong style="font-size: 15px">{{$statistic['total']}}</strong>
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="text-left" title="Male">
                                                            <span title="FIlle">F : {{$statistic['nbreF']}}</span>
                                                        </div>
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="text-right" title="Female">
                                                            <span title="Garçon">G : {{$statistic['nbreM']}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table class="table table-striped table-bordered nowrap mt-3" id="myTable">
                                            <thead>
                                                <tr>
                                                    <th style="width: 5%">Photo</th>
                                                    <th class="py-2">Matricule</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Genre</th>
                                                    <th>Date de nais...</th>
                                                    <th>Lieu de nais...</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <!-- content Table -->
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="upload" tabindex="-1" role="dialog" aria-labelledby="uploadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="uploadLabel">Import File Student</h5>
        </div>
        <form action="{{route('student.file')}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="modal-body px-3 py-4">
                <div class="form-group mt-2">
                    <span class="d-flex justify-content-between mb-2">
                        <label for="firstNameUser">Charger la fiche<span class="text-danger">*</span> : </label>
                        <a href="{{route('student.download')}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="DownLoad File Example"><i class="fas fa-download mx-0"></i></a>
                    </span>
                    <input type="file" name="files" id="firstNameUser" class="form-control" placeholder="Charger le fichier de format Excel">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('student.data1') }}',
                columns: [
                    { data: 'image', className: "text-center fw-bold py-1", orderable: false, searchable: false},
                    { data: 'matricule', className: "text-center py-1" },
                    { data: 'firstName', className: "py-1" },
                    { data: 'lastName', className: "py-1" },
                    { data: 'genre', className: "text-center py-1" },
                    { data: 'dateBirth', className: "text-center py-1" },
                    { data: 'placeBirth', className: "text-center py-1"},
                    { data: 'action', className: "text-center py-1", orderable: false, searchable: false}
                ],
                pageLength: 10,
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
                }
            });
        })
    </script>
@endsection