
@extends('app')
@section('title', 'Setting')
@section('content')
@section('link')
<link rel="stylesheet" href="{{asset('bower_components/select2/dist/css/select2.min.css')}}"/>
@endsection
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="card">
                    <div class="card-header mb-0 pb-0">
                        <div class="d-flex justify-content-between pb-0">
                            <h4>Parametrage d'établissement</h4>
                            <span class="form-control-variant">Les champ avec asterisk (<code>*</code>) sont obligatoires.</span>
                            <span>
                                <a href="{{route('setting.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                            </span>
                        </div>
                    </div>
                    <hr class="my-0 mx-3">
                    <div class="card-block mt-2">
                        <form action="{{route($school ? 'setting.update':'setting.store',$school ? $school->id:'')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            @method($school ? 'put':'post')
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="dren" class="block">DREN<span class="text-danger">*</span> : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <select  name="dren" id="dren" class="form-control select2 bg-white @error('dren') is-invalid @enderror">
                                        <option value="">Select one option</option>
                                        @foreach ($dren as $item)
                                        <option value="{{$item->id}}" {{old('dren') == $item->id ? 'selected':''}} {{$school ? ($school->get_dren_id == $item->id ? 'selected':null):null}}>{{ucwords($item->libelle)}}</option>
                                        @endforeach
                                    </select>
                                    @error('dren')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="emailSchool" class="block">E-mail Etablissement<span class="text-danger">*</span> : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="email" id="emailSchool" name="emailSchool" class="form-control @error('emailSchool') is-invalid @enderror" value="{{old('emailSchool', $school ? $school->address_email:'')}}" placeholder="Entrez l'adresse E-mail de l'établissement">
                                    @error('emailSchool')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="addrePostal" class="block">Adresse Postale : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="text" id="addrePostal" name="addrePostal" class="form-control @error('addrePostal') is-invalid @enderror" value="{{old('addrePostal', $school ? $school->addres_postal:'')}}" placeholder="Entrez l'adresse postale de l'établissement">
                                    @error('addrePostal')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="numPhon" class="block">Téléphone établissement<span class="text-danger">*</span> : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="text" id="numPhon" name="telephonSchool" class="form-control @error('telephonSchool') is-invalid @enderror" value="{{old('telephonSchool', $school ? $school->phon_school:'')}}" maxlength="10" placeholder="Entrez le numéro de téléphone de l'établissement">
                                    @error('telephonSchool')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="city" class="block">Ville établissement<span class="text-danger">*</span> : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="text" id="city" name="citySchool" class="form-control @error('citySchool') is-invalid @enderror" value="{{old('citySchool', $school ? $school->school_city:'')}}" placeholder="Entrez la ville de l'établissement">
                                    @error('citySchool')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="iepSchool" class="block">IEP (Enseignement primaire) : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="text" id="iepSchool-2" name="iepSchool" class="form-control @error('nameSchool') is-invalid @enderror" value="{{old('iepSchool', $school ? $school->address_iep:'')}}" placeholder="Entrez l'adresse IEP de l'établissement">
                                    @error('iepSchool')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label class="col-form-label" for="img">Logo de l'établissement<span class="text-danger">*</span> :</label>
                                </div>
                                <div class="col-sm-10">
                                    <input type="file" name="img" id="img" class="form-control w-100">
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="created" class="block">Date de creation : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="date" id="created" name="created" class="form-control @error('created') is-invalid @enderror" value="{{old('created', $school ? $school->create_school:'')}}" title="Date de création d'établissement">
                                    @error('created')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4 col-lg-2 text-right">
                                    <label for="opening" class="block">Date d'ouverture : </label>
                                </div>
                                <div class="col-md-8 col-lg-10">
                                    <input type="date" id="opening" name="opening" class="form-control @error('opening') is-invalid @enderror" value="{{old('opening', $school ? $school->open_school:'')}}" title="Date d'ouverture de l'établissement">
                                    @error('opening')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row my-4" style="display: {{ $school ? 'none':null }}">
                                <label class="col-sm-2 col-form-label"></label>
                                <div class="col-sm-10 mt-3">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <h4 class="sub-title">Type d'enseignement</h4>
                                            <div class="row">
                                                @foreach ($types as $type)
                                                <div class="col-md-6">
                                                    <div class="form-group text-left">
                                                        <input type="checkbox" name="type[]"  class="border-checkbox {{$type->id == 4 ? 'type':''}}" data-div="{{$type->id}}" value="{{$type->id}}" id="{{$type->id}}" {{$schoolType ? (getVerify($schoolType, $type->id, 'type_enseignement_id') ? 'checked':''):'checked'}}>
                                                        <label class="border-checkbox-label mb-0" for="{{$type->id}}">{{ucfirst($type->type_enseignement)}}</label>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="col-sm-3" id="divSerie">
                                            <h4 class="sub-title">Gestion des séries</h4>
                                            @foreach ($series as $serie)
                                            <div class="form-group">
                                                <input type="checkbox" name="series[]" class="border-checkbox series" value="{{$serie->id}}" id="{{$serie->id}}" {{$schoolSerie ? (getVerify($schoolSerie, $serie->id, 'serie_id') ? 'checked':''):'checked'}} >
                                                <label class="border-checkbox-label mb-0" for="{{$serie->id}}">{{ucfirst($serie->serie)}}</label>
                                            </div>
                                            @endforeach
                                        </div>
                                        <div class="col-sm-3">
                                            <h4 class="sub-title">Autres principes</h4>
                                            <div class="form-group text-left">
                                                <input type="checkbox" name="classe" class="border-checkbox" id="classe" value="1" {{$school ? ($school->letter_class ? 'checked':''):'checked'}}>
                                                <label class="border-checkbox-label mb-0" for="classe">Classe avec des lettres</label>
                                            </div>
                                            <div class="form-group text-left">
                                                <input type="checkbox" name="boxCash" class="border-checkbox" id="boxCash" value="1" {{$school ? ($school->box ? 'checked':''):'checked'}}>
                                                <label class="border-checkbox-label mb-0" for="boxCash">Gestion de la caisse</label>
                                            </div>
                                            <div class="form-group text-left" id="divAutre" style="display: none">
                                                <span class="mr-2">
                                                    <input type="checkbox"  name="transport" class="border-checkbox" id="transport" value="1" {{$school ? ($school->transport ? 'checked':''):'checked'}}>
                                                    <label class="border-checkbox-label mb-0" for="transport">Bus</label>
                                                </span>
                                                <span class="ml-2">
                                                    <input type="checkbox" name="cantine" class="border-checkbox" id="cantine" value="1" {{$school ? ($school->canteen ? 'checked':''):'checked'}}>
                                                    <label class="border-checkbox-label mb-0" for="cantine">Cantine </label>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex">
                                        <div class="form-group text-left" id="artMusique">
                                            <input type="checkbox" name="autres" class="border-checkbox" id="autres" value="1" {{$school ? ($school->musique_aplastique ? 'checked':''):''}}>
                                            <label class="border-checkbox-label mb-0" for="autres">Arts Plastique + Musique</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr class="text-center mt-lg-5" style="display: {{ $school ? 'none':null }}">
                            <div class="text-center">
                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider les informations</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function(){
        if($('.type').data('div') == 4){
            $('.type').prop('checked') ? $('#divSerie').slideDown():$('#divSerie').slideUp();
        }
        $('.type').on('click', function(){
            if($(this).data('div') == 4 && $(this).prop('checked')){
                $('#divSerie').slideDown(); $('.series').prop('checked', true);
            }
            else{
                $('#divSerie').slideUp(); $('.series').prop('checked', false);
            }

            if(($(this).data('div') == 3 || $(this).data('div') == 4) && $(this).prop('checked')){
                $('.series').prop('checked', true); // $('#artMusique').slideDown(); 
            }
            else{
                $('.series').prop('checked', false); // $('#artMusique').slideUp(); 
            }
        });

        $('#numPhon').on('keypress', function(e) {
            var charCode = e.which ? e.which : e.keyCode;
            if (charCode < 48 || charCode > 57) {
                e.preventDefault(); // Empêche la saisie si ce n'est pas un chiffre
            }
        });

        if($('#boxCash').is(':checked')){
            $('#divAutre').slideDown();
        }
        else{
            $('#divAutre').slideUp();
        }

        $('#boxCash').on('click', function() {
            if($(this).is(':checked')){
                $('#transport, #cantine').prop('checked', true);
               $('#divAutre').slideDown(); 
            }
            else{
                $('#transport, #cantine').prop('checked', false);
                $('#divAutre').slideUp();
            }
        });


        $('#dren').select2();
    })
</script>
@endsection