@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0">
                                    <h4>Scolarités</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addFraisModal" title="Add New scolarity Fee"><i class="fas fa-exchange-alt m-0"></i></button>
                                    </span>                                
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($data as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}} menuStep" id="{{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" data-lib="{{$item['libelle']}}" data-toggle="tab" href="#home{{$item['nbre']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ ucfirst(changeVal($item['libelle'])) }}
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($data as $item)
                                        <div class="tab-pane {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" id="home{{$item['nbre']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Montants</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $i = 1; @endphp
                                                    @foreach ($item['data'] as $val)
                                                    <tr>
                                                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                        <td class="text-left pl-3">
                                                            {{$val['niveau'] == 1 ? 'Tout les niveaux':ucfirst($val->level->level)}}
                                                        </td>
                                                        <td class="text-center">{{preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', $val->amount->montant)}} FR CFA</td>
                                                        <td style="width: 20%" class="py-0">
                                                            <div class="card-block remove-label m-0 py-2 text-center">
                                                                <button class="getDelet btn btn-inverse btn-outline-inverse btn-icons" title="Delete" data-id="{{$val->id}}" data-amount="{{$val->amount->montant}}" data-toggle="modal" data-target="#deleteModalCenter"><i class="far fa-trash-alt"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="addFraisModal" tabindex="-1" role="dialog" aria-labelledby="addFraisModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addFraisModalLongTitle">Add Scolarity Fee</h5>
            <strong style="font-size: 17px">{{$year['school_year']}}</strong>
        </div>
        <form action="{{route('scolarite.store')}}" method="post">
            @csrf
            <div class="modal-body py-3">
                <input type="hidden" name="type" id="type">
                <input type="hidden" name="year" value="{{$year['id']}}">
                <div class="form-group pt-2">
                    <label for="amount" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                </div>
                <div class="form-group">
                    <label class="form-label">Montant pour tout les niveau :</label>
                    <span class="ml-3">
                        <input type="radio" id="oui" name="statut" value="oui" checked><label for="oui" class="mx-1">oui</label>
                        <input type="radio" id="non" name="statut" value="non"><label for="non" class="ml-1">non</label>
                    </span>
                </div>
                <div class="form-group mb-3" id="addLevel" style="display: none">
                    <label for="level" class="form-label text-muted"><span id="monText"></span> <span class="text-danger">*</span> :</label>
                    <select name="level" id="level" class="form-control select2 bg-white">
                        <option value="" class="text-muted">Selection one option</option>
                    </select>    
                </div>
                <div class="form-group" id="blockText" style="display: none">
                    <label for="checkbox">Gestion des séries </label> <input type="checkbox" class="mx-1" id="checkbox">
                </div>
                <div class="form-group mb-3" id="addSerie" style="display: none">
                    <label for="serie" class="form-label text-muted">Série <span class="text-danger">*</span> :</label>
                    <select name="serie" id="serie" class="form-control select2 bg-white">
                        <option value="" class="text-muted">Selection one option</option>
                    </select>    
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal désactif discipline -->
<div class="modal fade" id="deleteModalCenter" tabindex="-1" role="dialog" aria-labelledby="deleteModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="deleteModalLongTitle">Delete Data</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <p id="addVal"></p>
                    <p class="my-0">
                        <strong>Vous êtes sur le point de supprimer ce montant !</strong>
                    </p>
                    <span>Cliquez sur 'Valider'.</span>
                </div>
            </div>
            </div>
            <form method="post" id="myDelete">
                @csrf
                @method('put')
                <input type="hidden" name="type" id="deletType">
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("scolarite");
            
            $('#amount').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });


            $('input[type="radio"]').on('change', function() {
                $('.level,.serie').remove();
                if($(this).val() == "non"){
                    $('#addLevel').slideDown();
                    $('#level').attr('required', true);
                    $('#monText').text($("#type").val() == 'supérieur' ? 'Filières':'Niveaux');
                    addLevel();
                }
                else{
                    $('#level').attr('required', false);
                    $('#addLevel, #addSerie, #blockText').slideUp();
                    $('#checkbox').prop('checked', false);
                }
            });


            $('#level').on('change', function() {
                $(this).val() > 13 ?
                $('#blockText').slideDown():
                $('#blockText').slideUp();
            });


            $('#checkbox').on('click', function() {
                $('.serie').remove();
                if($(this).is(':checked')){
                    $('#serie').attr('required', true);
                    $('#addSerie').slideDown();
                    addSerie();
                }
                else{
                    $('#serie').attr('required', false);
                    $('#addSerie').slideUp();
                }
            });


            $('#type').val($("#active").data('lib'));
            $('.nav-link').on('click', function() {
                $('#type').val($(this).data('lib'));
            });


            $(document).on('click', '.getDelet', function() {
                $('#data').remove(); $amount = $(this).data('amount');
                $id = $(this).data('id'); $('#deletType').val($("#type").val());
                $('#myDelete').attr('action', debutUrl[0]+'scolarite/destroy/'+$id); // Add action form Modal
                $('#addVal').append('<h5 class="mb-1 mt-2" id="data">'+formatVal($amount)+' FR CFA</h4>');
            });


            function addLevel()
            {
                $.ajax({
                    url: '{{route('scolarite.create')}}',
                    method: 'GET',
                    data: {
                        type: $("#type").val()
                    },
                    success: function(data){
                        $i = 0;
                        while($i < data.length){
                            $('#level').append('<option value="'+data[$i].id+'" data-code="'+data[$i].code+'" class="level">'+strUcFirst(data[$i].level)+'</option>');
                            $i++;
                        }
                    }
                });
            }


            function addSerie()
            {
                $.ajax({
                    url: '{{route('scolarite.edit')}}',
                    method: 'GET',
                    data: {
                        type: $("#type").val(),
                        level: $('#level option:selected').data('code')
                    },
                    success: function(data){
                        $i = 0;
                        while($i < data.length){
                            $('#serie').append('<option value="'+data[$i].id+'" class="serie">'+strUcFirst(data[$i].serie)+'</option>');
                            $i++;
                        }
                    }
                });
            }

            function strUcFirst($text)
            {
                return ($text+'').charAt(0).toUpperCase() + ($text+'').substr(1);
            }


            function formatVal($val)
            {
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }
        })
    </script>
@endsection