@extends('app')
@section('title', 'School year')
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>{{$data ? 'Edit ':'Add New '}}School Year</h4>
                                    <span class="form-control-variant">Les champ avec asterisk (<code>*</code>) sont obligatoires.</span>
                                    <span>
                                        <a href="{{route('school_year.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block my-3 px-5">
                                <form action="{{route($data ? 'school_year.update':'school_year.store', $data ? $data->id:'')}}" method="post">
                                    @csrf
                                    @method($data ? 'put':'post')
                                    <div class="form-group row my-3">
                                        <label class="col-sm-2 col-form-label" for="schoolYear">Année scolaire<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="schoolYear" id="schoolYear" class="form-control form-control-normal @error('schoolYear') is-invalid @enderror" value="{{ old('schoolYear',$data ? $data->school_year:'') }}" placeholder="Année scolaire (2024-2025)">
                                            @error('schoolYear')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label" for="sexeUser">Découpage<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                           @foreach ($decoupage as $decoup)
                                            <div class="form-check form-check-inline">
                                                <label class="form-check-label">
                                                    <input type="radio" name="decoupage" id="{{$decoup}}" class="form-check-input" value="{{$decoup}}" {{ old('sexe') == $decoup ? 'checked':null }} {{$data ? ($data->decoupage == $decoup ? 'checked':''):''}}> {{ucfirst($decoup)}}
                                                </label>
                                            </div>
                                           @endforeach
                                           <br>
                                           @error('decoupage')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    @if ($data)
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label" ></label>
                                        <div class="col-sm-10">
                                            <input type="checkbox" name="status" id="status" {{$data->status ? 'checked':''}}>
                                            <label for="status" class="mx-1 form-control-variant">{{$data->status ? 'Actif':'Inactif'}}</label>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider cette étape</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection