@extends('app')
@section('title', 'Add new parent')
@section('link')
<style>
    #blinks {
        color: red !important;
        font-size: 15px !important;
        animation: blinker 1.5s linear infinite;
    }
    @keyframes blinker {  
      50% { opacity: 0; }
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="card px-2">
                    <div class="card-header my-0 pb-0">
                        <div class="d-flex justify-content-between mb-2">                        
                            <h4>Parent en charge des études</h4>
                            <span class="form-control-variant">Les champ avec asterisk (<code>*</code>) sont obligatoires.</span>
                            <span>
                                @if (!$parent)
                                <a href="{{route('parent.create')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-2" title="Refresh page" id="btnActual" style="display: none"><i class="fas fa-sync m-0"></i></a>
                                @endif
                                <a href="{{route( $parent ? 'parent.index':'inscription.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return back"><i class="fas fa-reply m-0"></i></a>
                            </span>
                        </div>
                    </div>
                    <hr class="my-0 mx-3">
                    <span class="form-control-variant text-center mt-3" id="blinks" style="display: none">Parent Existe ...</span>   
                    <div class="card-block mt-3">
                        <form action="{{route($parent ? 'parent.update':'parent.store', $parent ? $parent->id:null)}}" method="post">
                            @csrf
                            @method($parent ? 'put':'post')
                            <input type="hidden" name="id" value="" id="IdParent">
                            <div class="form-group row">        
                                <label class="col-sm-2 col-form-label text-right" for="phon1">Numéro de téléphone 1<span class="text-danger">*</span> :</label>
                                <div class="col-sm-10">
                                    <input type="text" name="phon1" id="phon1" class="form-control phon1 @error('phon1') is-invalid @enderror" value="{{old('phon1', $parent ? $parent->telephon1:null)}}" maxlength="10" placeholder="Entrez son numéro de téléphone principal">
                                    @error('phon1')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label text-right" for="phon2">Numéro de téléphone 2 :</label>
                                <div class="col-sm-10">
                                    <input type="text" name="phon2" id="phon2" class="form-control phon2 @error('phon2') is-invalid @enderror" value="{{old('phon2', $parent ? $parent->telephon2:null)}}" maxlength="10" placeholder="Entrez son numéro de téléphone 2 (facultatif)">
                                    @error('phon2')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label text-right" for="firstName">Nom<span class="text-danger">*</span> :</label>
                                <div class="col-sm-10">
                                    <input type="text" name="firstName" id="firstName" class="form-control @error('firstName') is-invalid @enderror" value="{{old('firstName', $parent ? $parent->first_name:null)}}" placeholder="Entre son nom ...">
                                    @error('firstName')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label text-right" for="latsName">Prénoms<span class="text-danger">*</span> :</label>
                                <div class="col-sm-10">
                                    <input type="text" name="latsName" id="latsName" class="form-control @error('latsName') is-invalid @enderror" value="{{old('latsName', $parent ? $parent->last_name:null)}}" placeholder="Entrez son prénoms ...">
                                    @error('latsName')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label text-right" for="sexeUser">Sexe<span class="text-danger">*</span> :</label>
                                <div class="col-sm-10">
                                    <span class="mr-3">
                                        <input type="radio" name="sexe" class="checkSexe" id="femme" data-div="F" value="F" {{ old('sexe') == 'F' ? 'checked':null }} {{$parent ? ($parent->sexe == 'F' ? 'checked':null):null}}>
                                        <label for="femme" class="mx-1 form-control-variant">Femme</label>
                                    </span>
                                    <span class="mx-3">
                                        <input type="radio" name="sexe" class="checkSexe" id="homme"data-div="H"  value="H" {{ old('sexe') == 'H' ? 'checked':null }} {{$parent ? ($parent->sexe == 'H' ? 'checked':null):null}}>
                                        <label for="homme" class="mx-1 form-control-variant">Homme</label>
                                    </span> <br>
                                    @error('sexe')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label text-right" for="profession">Profession<span class="text-danger">*</span> :</label>
                                <div class="col-sm-10">
                                    <input type="text" name="profession" id="profession" class="form-control @error('profession') is-invalid @enderror" value="{{old('profession', $parent ? $parent->profession:null)}}" placeholder="Entrez sa profession ...">
                                    @error('profession')
                                        <span class="form-bar text-danger" role="alert">
                                            {{$message}}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row" id="getMsg" style="display: none">
                                <label class="col-sm-2 col-form-label" for="profession"></label>
                                <div class="col-sm-10">
                                    <label class="mx-2 col-form-label" for="info" id="message"></label>
                                    <input type="checkbox" name="info" id="info" value="1">
                                </div>
                            </div>

                            @if ($parent)
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="profession"></label>
                                <div class="col-sm-10">
                                    <span class="mr-3">
                                        <input type="checkbox" name="messagerie" id="messagerie" value="1" {{$parent->messagerie ? 'checked':null}}>
                                        <label for="messagerie" class="mx-1 form-control-variant">Message</label>
                                    </span>
                                    <span class="mx-3">
                                        <input type="checkbox" name="status" id="status" value="1" {{$parent->status ? 'checked':null}}>
                                        <label for="status" class="mx-1 form-control-variant">Status</label>
                                    </span>
                                </div>
                            </div>
                            @endif
                            <hr class="text-center" style="margin-top: 30px">
                            <div class="text-center">
                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider cette étape</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $(document).ready(function(){

        $('#phon1,  #phon2').on('keypress', function(e) {
            var charCode = e.which ? e.which : e.keyCode;
            if (charCode < 48 || charCode > 57) {
                e.preventDefault(); // Empêche la saisie si ce n'est pas un chiffre
            }
        });

       // Récherché un parent à partir de son numer de téléphone
       $('#phon1, #phon2').change(function() {
            let val = $(this).val();
            if(val){
                $.ajax({
                    url: '{{ route('parent.search2') }}',
                    method: 'GET',
                    data: {
                        data: val
                    },
                    success: function(response){
                        // Traitez la réponse et mettez à jour l'interface utilisateur
                        if(response['id']){
                            $('#phon1').val(response['telephon1']);
                            $('#phon1').attr('disabled',true);
                            $('#phon2').val(response['telephon2']);
                            $('#phon2').attr('disabled',true);
                            $('#firstName').val(response['first_name']);
                            $('#firstName').attr('disabled',true);
                            $('#latsName').val(response['last_name']);
                            $('#latsName').attr('disabled',true);
                            $('#profession').val(response['profession']);
                            $('#profession').attr('disabled',true);
                            response['sexe'] == 'F' ? $('#femme').attr('checked','checked'):$('#homme').attr('checked','checked')
                            $('#femme').attr('disabled',true); $('#homme').attr('disabled',true);
                            $('#IdParent').val(response['id']);
                            $('#blinks, #btnActual').slideDown();
                        }
                        else{
                            $('#blinks, #btnActual').slideUp();
                        }
                    },
                });
            }
        });

        // Récupérer la valeur de l'attribut 'data-div' de l'élément cliqué
        $('.checkSexe').click(function() {
            if($(this).data('div') == 'H'){
                $('#message').text('Etes-vous le père biologique de l\'enfant ?');
                $('#getMsg').slideDown();
            }
            else if($(this).data('div') == 'F'){
                $('#message').text('Etes-vous la mère biologique de l\'enfant ?');
                $('#getMsg').slideDown();
            }
        });
    })
</script>
@endsection