@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4 class="mb-0">Moyennes</h4>
                                    <strong>{{ date('d/m/Y') }}</strong>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($data as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}} menuStep" id="{{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" data-lib="{{$item['libelle']}}" data-toggle="tab" href="#home{{$item['nbre']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ ucfirst(changeVal($item['libelle'])) }} [{{count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])}}]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($data as $item)
                                        <div class="tab-pane {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" id="home{{$item['nbre']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Effectif</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $i = 1; @endphp
                                                    @foreach ($item['data'] as $val)
                                                    <tr>
                                                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                        <td class="text-center">
                                                            {{ucfirst($val['libelle'])}}
                                                        </td>
                                                        <td class="text-center">{{$val['inscrits'] <= 9 ? '0'.$val['inscrits']:$val['inscrits']}}/{{$val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']}}</td>
                                                        <td style="width: 20%" class="py-0">
                                                            <div class="card-block remove-label m-0 py-2 text-center">
                                                                {{-- @if ($val['type'] == 'primaire') --}}
                                                                    <button class="btn btn-inverse btn-outline-inverse btn-icons mr-1 btnModal" data-lib="{{ ucfirst($val['libelle']) }}" data-id="{{ $val['id'] }}"><i class="fa fa-list mx-0"></i></button>
                                                                {{-- @else
                                                                    <a href="{{route('moyenne.show', $val['id'])}}" class="btn btn-inverse btn-outline-inverse btn-icons" title="Liste de classe"><i class="fas fa-list m-0"></i></a>
                                                                @endif --}}
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="getModal" tabindex="-1" role="dialog" aria-labelledby="getModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header bg-dark py-2">
        <h5 class="modal-title" id="getModalLongTitle">Select</h5>
        <strong class="pt-2" id="libelles" style="font-size: 17px">
            {{-- <i class="fas fa-layer-group"></i> --}}
        </strong>
      </div>
        <form action="{{ route('moyenne.show') }}" method="post">
            @csrf
            @method('get')
            <div class="modal-body">
                <div class="m-b-30">
                    <input type="hidden" name="class" id="classId">
                    <label for="select">Select One Option<span class="text-danger">*</span> : </label>
                    <select name="select" class="form-control" id="select">
                        {{-- <option value=" ">Select One option</option> --}}
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            $('.btnModal').on('click', function() {
                $('.option').remove();
                $('#classId').val($(this).data('id'));
                $('#libelles').text($(this).data('lib'));
                $.ajax({
                    url: '{{ route('resultat.search') }}',
                    method: 'GET',
                    data: {
                        id: $(this).data('id')
                    },
                    success: function(rsps){
                        if(rsps.status == 200){
                            $i = 0; $data = rsps.data;
                            while ($i < $data.length) {
                                $('#select').append(
                                    '<option value="'+$data[$i].id+'" class="option">'+$data[$i].libelle+'</option>'
                                );
                                $i++;
                            }
                        }
                        else{
                           $('#select').append('<option class="option">Donnée Introuvable</option>'); 
                        }
                        const modal = new bootstrap.Modal(document.getElementById('getModal'));
                        modal.show();
                    }
                });
            })
        })
    </script>
@endsection