@extends('app')
@section('title', 'Gestion des évaluations')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des évaluations</h4>
                                    <strong id="days" style="display: none">{{ date('d/m/Y') }}</strong>
                                    <span id="sectionPrimary" style="display: none">
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-1" title="List composed" data-toggle="modal" data-target="#ListModal"><i class="fa fa-list mx-0"></i></button>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" id="AddCompo" title="Add Composed" data-toggle="modal" data-target="#addCompoModal"><i class="fa fa-plus mx-0"></i></button>
                                    </span>
                                </div>
                            </div>
                            <hr class="mt-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($data as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}} menuStep" id="{{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" data-lib="{{$item['libelle']}}" data-toggle="tab" href="#home{{$item['nbre']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ ucfirst(changeVal($item['libelle'])) }} [{{count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])}}]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($data as $item)
                                        <div class="tab-pane {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" id="home{{$item['nbre']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%">N°</th>
                                                        <th class="text-center">Classe</th>
                                                        <th class="text-center">Effectif</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $i = 1; @endphp
                                                    @foreach ($item['data'] as $val)
                                                    <tr>
                                                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                        <td class="text-center">
                                                            {{ucfirst($val['libelle'])}}
                                                        </td>
                                                        <td class="text-center">{{$val['inscrits'] <= 9 ? '0'.$val['inscrits']:$val['inscrits']}}/{{$val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']}}</td>
                                                        <td style="width: 20%" class="py-0">
                                                            <div class="card-block remove-label m-0 py-2 text-center">
                                                                <button class="btn btn-sm btn-inverse btn-outline-inverse  btn-icons px-2 getEvaluation" title="Veiw Evaluated" data-val="{{$val['id'].'_'.$val['level_id']}}"><i class="fas fa-list m-0"></i></button>
                                                                @if ($val['type'] == 'secondaire')
                                                                <a href="{{ route('evaluation.devoir', $val['id']) }}" class="btn btn-inverse btn-outline-inverse  btn-icons px-2 ml-2" title="Devoir Program"><i class="fas fa-exchange-alt m-0"></i></a>
                                                                @endif
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="matierModal" tabindex="-1" role="dialog" aria-labelledby="matierModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="matierModalLongTitle">Choise Selected</h5>
        </div>
        <form action="#" method="post" id="formEvaluats">
            @csrf
            @method('get')
            <div class="modal-body">
                <div class="m-b-30">
                    <label for="seletMatter">Select One Option<span class="text-danger">*</span> : </label>
                    <select name="select" class="form-control" id="seletMatter">
                        {{-- <option value=" ">Select One option</option> --}}
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal New composition -->
<div class="modal fade" id="addCompoModal" tabindex="-1" aria-labelledby="addCompoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title fs-5" id="addCompoModalLabel">Nouvelle composition</h5>
        </div>
        <form action="{{route('composition.store')}}" method="post">
            @csrf
            <div class="modal-body pb-0">
                <div class="m-b-30">
                    <label for="seletTypeEval">Type Evaluation<span class="text-danger">*</span> : </label>
                    <select name="typeEval" class="form-control" id="seletTypeEval">
                        <option value="1">Select One option</option>
                        <option value="composition">Composition</option>
                        <option value="examen blanc">Examen Blanc</option>
                        <option value="examen final">Examen Final</option>
                    </select>
                </div>

                <div class="m-b-30">
                    <label for="dateEval">Date Evaluation<span class="text-danger">*</span> : </label>
                    <input type="date" name="dateEval" class="form-control" id="dateEval">
                </div>

                <div class="mb-0" id="divLevel" style="display: none">
                    <label for="seletTypeEval">Niveaux concernés<span class="text-danger">*</span> : </label>
                    <p id="section1">
                        <samp class="prescolaire" style="display: none">
                            <span class="mr-4" title="Petite Section">
                                <input type="checkbox" class="composition" name="ps" id="ps" value="1">
                                <label for="ps" class="mx-1">PS</label>
                            </span>
                            <span class="mr-4" title="Moyenne Section">
                                <input type="checkbox" class="composition" name="ms" id="ms" value="1">
                                <label for="ms" class="mx-1">MS</label>
                            </span>
                            <span class="mr-4" title="Grande Section">
                                <input type="checkbox" class="composition" name="gs" id="gs" value="1">
                                <label for="gs" class="mx-1">GS</label>
                            </span>
                            <span class="mr-4" title="CPU">
                                <input type="checkbox" class="composition" name="cpu" id="cpu" value="1">
                                <label for="cpu" class="mx-1">CPU</label>
                            </span>
                        </samp>
                        <span class="primaire" style="display: none">
                            <span class="mr-4" title="CP1">
                                <input type="checkbox" class="composition" name="cp1" id="cp1" value="1">
                                <label for="cp1" class="mx-1">CP1</label>
                            </span>
                            <span class="mr-0" title="CP2">
                                <input type="checkbox" class="composition" name="cp2" id="cp2" value="1">
                                <label for="cp2" class="mx-1">CP2</label>
                            </span>
                        </span>
                    </p>
                    <p id="section2" class="primaire" style="display: none">
                        <span class="mr-4" title="CE1">
                            <input type="checkbox" class="composition" name="ce1" id="ce1" value="1">
                            <label for="ce1" class="mx-1">CE1</label>
                        </span>
                        <span class="mr-4" title="CE2">
                            <input type="checkbox" class="composition" name="ce2" id="ce2" value="1">
                            <label for="ce2" class="mx-1">CE2</label>
                        </span>
                    
                        <span class="mr-4" title="CM1">
                            <input type="checkbox" class="composition" name="cm1" id="cm1" value="1">
                            <label for="cm1" class="mx-1">CM1</label>
                        </span>
                        <span class="mr-0" title="CM2">
                            <input type="checkbox" class="examen" name="cm2" id="cm2" value="1">
                            <label for="cm2" class="mx-1">CM2</label>
                        </span>
                    </p>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- @Modal List Composition-->
<div class="modal fade" id="ListModal" tabindex="-1" role="dialog" aria-labelledby="ListModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="ListModalTitle">Liste des compositions</h5>
          <span id="libelle" style="font-size: 18px">{{$date}}</span>
        </div>
        <div class="modal-body">
            <div class="dt-responsive table-responsive">
                <table class="table table-striped table-bordered nowrap">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 10%">N°</th>
                            <th class="text-center" style="width: 40%">Libelle</th>
                            <th class="text-center" style="width: 25%">Date</th>
                            <th class="text-center" style="width: 25%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tbody>
                            @php $i = 1; @endphp
                            @forelse ($compos as $compo)
                            <tr>
                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                <td class="mx-3">{{ ucfirst($compo->evaluated->libelle) }}</td>
                                <td class="text-center">{{date('d-m-Y', strtotime( $compo->created ?? $compo->evaluated->date))}}</td>
                                <td class="mx-3 py-0">
                                    <div class="card-block remove-label m-0 py-2 text-center">
                                        <button class="btn btn-inverse btn-outline-inverse btn-icons text-center px-2 mx-1 btnCpts" data-id="{{ $compo->id }}" title="Edit" data-sujet="edit"><i class="far fa-edit m-0"></i></button>
                                        <button class="btn btn-inverse btn-outline-inverse btn-icons text-center px-2 mx-1 btnCpts" data-id="{{ $compo->id }}" title="Delete" data-sujet="detele"><i class="far fa-trash-alt m-0"></i></button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">Données introuvables</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
          {{-- <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="formUrl">Editer</a> --}}
        </div>
      </div>
    </div>
</div>
<!-- Modal Edit Composition -->
<div class="modal fade" id="editCompoModal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="{{ route('composition.update') }}" method="post">
                @csrf
                <div class="modal-header bg-dark py-2">
                    <h5 class="modal-title" id="editCompoModalTitle">Edit Composition</h5>
                    <span id="libelle" style="font-size: 18px">{{$date}}</span>
                </div>
                <div class="modal-body pb-0">
                    <div class="m-b-30 text-center">
                        <label style="font-size: 19px"><strong id="selectEdit"></strong></label>
                        <input type="hidden" name="evaluation" id="idEvaluat">
                    </div>

                    <div class="m-b-30">
                        <label for="dateEval">Date Evaluation<span class="text-danger">*</span> : </label>
                        <input type="date" name="dateEval" class="form-control" id="dateEdit">
                    </div>

                    <div class="mb-0">
                        <label for="seletTypeEval">Niveaux concernés<span class="text-danger">*</span> : </label>
                        <p id="pl-2">
                            <samp class="prescolaire ml-2" style="display: none">
                                <span class="mr-4" title="Petite Section">
                                    <input type="checkbox" class="composition" name="ps" id="psEdit" value="1">
                                    <label for="psEdit" class="mx-1">PS</label>
                                </span>
                                <span class="mr-4" title="Moyenne Section">
                                    <input type="checkbox" class="composition" name="ms" id="msEdit" value="1">
                                    <label for="msEdit" class="mx-1">MS</label>
                                </span>
                                <span class="mr-4" title="Grande Section">
                                    <input type="checkbox" class="composition" name="gs" id="gsEdit" value="1">
                                    <label for="gsEdit" class="mx-1">GS</label>
                                </span>
                                <span class="mr-4" title="CPU">
                                    <input type="checkbox" class="composition" name="cpu" id="cpuEdit" value="1">
                                    <label for="cpuEdit" class="mx-1">CPU</label>
                                </span>
                            </samp>
                            <span class="primaire ml-2" style="display: none">
                                <span class="mr-4" title="CP1">
                                    <input type="checkbox" class="composition" name="cp1" id="cp1Edit" value="1">
                                    <label for="cp1Edit" class="mx-1">CP1</label>
                                </span>
                                <span class="mr-0" title="CP2">
                                    <input type="checkbox" class="composition" name="cp2" id="cp2Edit" value="1">
                                    <label for="cp2Edit" class="mx-1">CP2</label>
                                </span>
                            </span>
                        </p>
                        <p class="primaire ml-2" style="display: none">
                            <span class="mr-4" title="CE1">
                                <input type="checkbox" class="composition" name="ce1" id="ce1Edit" value="1">
                                <label for="ce1Edit" class="mx-1">CE1</label>
                            </span>
                            <span class="mr-4" title="CE2">
                                <input type="checkbox" class="composition" name="ce2" id="ce2Edit" value="1">
                                <label for="ce2Edit" class="mx-1">CE2</label>
                            </span>
                        
                            <span class="mr-4" title="CM1">
                                <input type="checkbox" class="composition" name="cm1" id="cm1Edit" value="1">
                                <label for="cm1Edit" class="mx-1">CM1</label>
                            </span>
                            <span class="mr-0" title="CM2">
                                <input type="checkbox" class="examen" name="cm2" id="cm2Edit" value="1">
                                <label for="cm2Edit" class="mx-1">CM2</label>
                            </span>
                        </p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Editer</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Modal Delete Composition -->
<div class="modal fade" id="deleteCompoModal" tabindex="-1" role="dialog" aria-labelledby="deleteCompoModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="{{ route('composition.destroy') }}" method="post">
                @csrf
                <div class="modal-header bg-dark py-2">
                    <h5 class="modal-title" id="deleteCompoModalTitle">Delete Composition</h5>
                </div>
                <div class="modal-body">
                    <div class="mb-2 text-center">
                        <label style="font-size: 19px"><strong id="libDelete"></strong></label> <br>
                        <span style="font-size: 16px">Fait le <span id="createdAt"></span></span>
                        <input type="hidden" name="id" id="idDelete">
                    </div>
                    <p class="my-0 text-center">Confirmez la suppression !!!</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $actif = $("#active").data('lib');
            if($actif == 'Prescolaire - Primaire' || $actif == 'Primaire' ||  $actif == 'Prescolaire'){
                $('#sectionPrimary').slideDown(); $('#days').slideUp();
                afficheSectionPrimaire($actif);
            }
            else{
                $('#sectionPrimary').slideUp()
                $('#days').slideDown();
            }

            $('.nav-link').on('click', function() {
                $actif = $(this).data('lib');
                if($actif == 'Prescolaire - Primaire' || $actif == 'Primaire' ||  $actif == 'Prescolaire'){
                    $('#sectionPrimary').slideDown(); $('#days').slideUp();
                    afficheSectionPrimaire($actif);
                }
                else{
                    $('#sectionPrimary').slideUp()
                    $('#days').slideDown();
                }
            });


            $('#AddCompo').on('click', function() {
                $('.periode').remove();
                $.ajax({
                    url: '{{ route('composition.create') }}',
                    method: 'GET',
                    success: function(data){
                       data['prescolaire'] ? $('.prescolaire').slideDown():$('.prescolaire').slideUp();
                       data['primaire'] ? $('.primaire').slideDown():$('.primaire').slideUp();
                    }
                });
            });


            $('#seletTypeEval').on('change', function() {
                $val = $(this).val();
                $val != 1 ? $('#divLevel').slideDown():$('#divLevel').slideUp();
                if($val == 'composition'){
                    $('.composition, .examen').prop('checked', true);
                }
                else{
                    $('.composition').prop('checked', false);
                    $('.examen').prop('checked', true);
                }
            });


            // Get list Compositions Or Matters ...................
            $(document).on('click', '.getEvaluation', function() {
                $('.matter').remove();
                $val = ($(this).data('val')).split('_');
                $('#formEvaluats').attr('action', geturl($val[1]) ? '{{ route('evaluation.matiere_evaluee') }}':'{{ route('composition.index') }}');
                if($(this).data('val')){
                    $.ajax({
                        url: geturl($val[1]) ? '{{ route('evaluation.matiere') }}':'{{ route('composition.show') }}',
                        method: 'GET',
                        data: {
                            id: $val[0],
                            level: $val[1]
                        },
                        success: function(data){
                            if(data.length){
                                $i = 0;
                                while ($i < data.length) {
                                    $('#seletMatter').append('<option value="'+data[$i].id+'_'+$val[0]+'" class="matter" title="'+data[$i].libelle+'">'+data[$i].abbreviated+'</option>');
                                    $i++;
                                }
                            }
                            else{
                                $('#seletMatter').append('<option class="matter">Donnée non disponible !</option>');
                            }
                            const editModal = new bootstrap.Modal(document.getElementById('matierModal'));
                            editModal.show();
                        }
                    });
                }
            });

            // Edit And Delete Click Composition ...................................
            $(document).on('click', '.btnCpts', function() {
                $val = $(this).data('id'); $sujet = $(this).data('sujet');
                if($val && $sujet){
                    $.ajax({
                        url: '{{ route('composition.search') }}',
                        method: 'GET',
                        data: { id: $val },
                        success: function(data){
                            if(data){
                                if($sujet == 'edit'){
                                    afficheEditInfo(data);
                                    $("#editCompoModal").modal("show"); // Affichage Le la Modal Edit Composition
                                }
                                else{
                                    afficheDeleteInfo(data);
                                    $("#deleteCompoModal").modal("show"); // Affichage Le la Modal Delete Composition
                                }
                                $('#ListModal').modal("hide"); // Fermerture De La Modal Liste Composition
                            }
                        }
                    });
                }
            });
            


            // Function Get Affiche ................
            function afficheSectionPrimaire($type){
                switch ($type) {
                    case 'Prescolaire - Primaire':
                        $('.primaire, .prescolaire').slideDown();
                        break;
                    case 'Primaire':
                        $('.primaire').slideDown();
                        break;
                    case 'Prescolaire':
                        $('.primaire').slideDown();
                        break;
                }
            }


            function afficheEditInfo($data){
                $('#selectEdit').text($data.libelle);
                $('#dateEdit').val($data.created);
                $('#idEvaluat').val($data.id);

                // Checkbox Element
                $('#psEdit').prop('checked', ($data.ps == 1 ? true:false));
                $('#msEdit').prop('checked', ($data.ms == 1 ? true:false));
                $('#gsEdit').prop('checked', ($data.gs == 1 ? true:false));
                $('#cpuEdit').prop('checked', ($data.cpu == 1 ? true:false));
                $('#cp1Edit').prop('checked', ($data.cp1 == 1 ? true:false));
                $('#cp2Edit').prop('checked', ($data.cp2 == 1 ? true:false));
                $('#ce1Edit').prop('checked', ($data.ce1 == 1 ? true:false));
                $('#ce2Edit').prop('checked', ($data.ce2 == 1 ? true:false));
                $('#cm1Edit').prop('checked', ($data.cm1 == 1 ? true:false));
                $('#cm2Edit').prop('checked', ($data.cm2 == 1 ? true:false));
            }

            function afficheDeleteInfo($data){
                $('#libDelete').text($data.libelle);
                $('#createdAt').text($data.date);
                $('#idDelete').val($data.id);
            }


            function geturl($id){
                if(($id < 10) || ($id == 17) ){
                    $return = false;
                }
                else if(($id > 9) && ($id < 17)){
                    $return = true;
                }
                return $return;
            }
        })
    </script>
@endsection