@extends('app')
@section('title', 'List Devoir')
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Pragramme Devoirs</h4>
                                    <strong style="font-size: 17px">{{ $classe->libelle. ' [ '.ucwords($cutting->cutting->libelle).']' }}</strong>
                                    <span>
                                        <a href="{{ route('evaluation.imprim',$classe->id.'_'.$cutting->id) }}" target="_blank" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-1" title="Return Back"><i class="fas fa-print mx-0"></i></a>
                                        <a href="{{route('evaluation.index')}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mt-0 mx-3">
                            <div class="card-block mx-lg-3 pt-lg-3">
                                <div class="table-responsive">
                                    <table class="table table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th scope="col" class="text-center" style="width: 16%">MATIERES</th>
                                                <th scope="col" class="text-center" style="width: 42%">MATIN</th>
                                                <th scope="col" class="text-center" style="width: 42%">APRES MIDI</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($matters as $matter)
                                            <tr>
                                                <th scope="col" class="pl-2 my-0" style="padding-top: 27px">{{ $matter['libelle'] }}</th>
                                                <td class="my-0 p-0">
                                                    <table class="m-0 p-0" style="width: 100%">
                                                        <tbody class="m-0 p-0">
                                                            <tr class="m-0">
                                                                @foreach ($matter['martins'] as $item)
                                                                    <td class="text-center py-1">
                                                                        {{ ucwords($item['jour']) }}<br> 
                                                                        <strong>{{ date('d/m/Y', strtotime($item['date'])) }}</strong><br>
                                                                        {{ $item['debut'] }} - {{ $item['fins'] }}
                                                                    </td>
                                                                @endforeach
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                                <td class="my-0 p-0">
                                                    <table class="m-0 p-0" style="width: 100%">
                                                        <tbody class="m-0 p-0">
                                                            <tr class="m-0">
                                                                @foreach ($matter['soirs'] as $item)
                                                                    <td class="text-center py-1">
                                                                        {{ ucwords($item['jour']) }} <br> 
                                                                        <strong>{{ date('d/m/Y', strtotime($item['date'])) }}</strong><br>
                                                                        {{ $item['debut'] }} - {{ $item['fins'] }}
                                                                    </td>
                                                                @endforeach
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<!-- Custom js -->
<script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection