@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .btn.btn-icons {
        border-radius: 50%;
        width: 30px;
        line-height: 20px;
        height: 30px;
        padding: 3px;
        text-align: center;
    }
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>Détail des Appels</h4>
                                    <div class="text-center text-muted" style="font-size: 17px">{{$class['libelle']}} - {{ucfirst($matter->matter->abbreviated ?? $matter->matter->libelle)}}</div>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-3" id="getAdd" title="Nouvel Appel" data-toggle="modal" data-target="#addAppelModal"><i class="fas fa-plus m-0"></i></button>
                                        <a href="{{route('appel.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($datas as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{$item['actif'] == 1 ? 'active':''}}" data-lib="{{$item['libelle']}}" id="{{$item['actif'] == 1 ? 'active':'inactif'}}" data-actif="{{$item['actif']}}" data-id="{{$item['id']}}" data-toggle="tab" href="#home{{$item['id']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ucfirst($item['libelle'])}}
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($datas as $item)
                                        <div class="tab-pane {{$item['actif'] == 1 ? 'active':''}}" id="home{{$item['id']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%"></th>
                                                        <th class="text-center" style="width: 10%">Matricule</th>
                                                        <th class="text-center" style="width: 35%">Nom & Prenoms</th>
                                                        <th class="text-center" style="width: 12%">Sexe</th>
                                                        <th class="text-center" style="width: 10%">Total absence</th>
                                                        <th class="text-center" style="width: 10%">Justifiées</th>
                                                        <th class="text-center" style="width: 10%">Non justifiées</th>
                                                        <th class="text-center" style="width: %">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($item['data'] as $student)
                                                    <tr>
                                                        <th class="text-center py-1">
                                                            <img src="{{ asset($student['sexe'] == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                        </th>
                                                        <td class="text-center">{{$student['matricule']}}</td>
                                                        <td class="text-left" title="{{ $student['name'] }}">{{ Str::limit($student['name'], '27', '...') }}</td>
                                                        <td class="text-center">{{ucfirst($student['sexe'] == 'F' ? 'Féminin':'Masculin')}}</td>
                                                        <td class="text-center">{{$student['nbre_abs'] <= 9 ? '0'.$student['nbre_abs']:$student['nbre_abs']}}H</td>
                                                        <td class="text-center">{{$student['nbre_abs_justif'] <= 9 ? '0'.$student['nbre_abs_justif']:$student['nbre_abs_justif']}}H</td>
                                                        <td class="text-center">{{$student['nbre_abs_injustif'] <= 9 ? '0'.$student['nbre_abs_injustif']:$student['nbre_abs_injustif']}}H</td>
                                                        <td style="width: 15%" class="py-0">
                                                            <div class="card-block remove-label m-0 py-2 text-center">
                                                                <a href="{{route('appel.edit',$item['id'].'_'.$matter->matter_id.'_'.$student['id'])}}" class="editEval btn btn-inverse btn-outline-inverse btn-icons" title="Détails"><i class="fas fa-align-justify m-0"></i></a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add New Appel -->
<div class="modal fade" id="addAppelModal" tabindex="-1" role="dialog" aria-labelledby="addAppelModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addAppelModalLongTitle">Nouvel Appel</h5>
        </div>
        <form action="{{route('appel.create')}}" method="post">
            @csrf
            @method('get')
            <input type="hidden" name="matter" value="{{$matter->matter_id}}">
            <input type="hidden" name="classed" value="{{$class->id}}">
            <input type="hidden" name="cutting" value="" id="idCutting">
            <div class="modal-body">
                <div class="m-b-30 mt-3">
                    <label for="date">Date d'appel<span class="text-danger">*</span> : </label>
                    <input type="date" name="date" class="form-control" id="date">
                </div>

                <div class="m-b-30 mt-3">
                    {{-- <label for="date">Période<span class="text-danger">*</span> : </label> --}}
                    <span class="mx-3">
                        <input type="radio" name="period" id="monning" value="1">
                        <label for="monning">Matin</label>
                    </span>
                    <span class="mx-3">
                        <input type="radio" name="period" id="afternoow" value="2">
                        <label for="afternoow">Après midi</label>
                    </span>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $actif = $("#active").data('actif');
            if($actif && $actif != 2){
                $('#getAdd').slideDown();
                $('#idCutting').val($('#active').data('id'));
            }
            else{
                $('#getAdd').slideUp();
                $('#idCutting').val();
            }
            $('.nav-link').on('click', function(){
                $actif = $(this).data('actif');
                $actif == 2 ? $('#getAdd').hide():$('#getAdd').slideDown();
                $('#idCutting').val($actif == 2 ? null:$(this).data('id'));
            });


            // Date du jour
            $('#date').val(new Date().toISOString().split('T')[0]);
            $('#date').attr('max', new Date().toISOString().split('T')[0]); // Limiter la date à celle d'aujourd'hui
            let heure = new Date().getHours().toString().padStart(2, '0');
            if(heure <= 12){
                $('#monning').prop('checked', true);
            }
            else{
                $('#afternoow').prop('checked', true);
            }

        })
    </script>
@endsection