@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/AlertifyJS/1.13.1/css/alertify.min.css">
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/themes/default.min.css"/>
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>{{$class['libelle']}} - {{'semaine '.($weeks <= 9 ? '0'.$weeks:$weeks)}}</h4>
                                    <div class="text-center text-muted" style="font-size: 17px">Appels du {{date('d-m-Y', strtotime($today))}}</div>
                                    <span>
                                        <a href="{{route('appel.primary', $class['id'])}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                    <input type="hidden" value="{{$class['id']}}" id="classId">
                                    <input type="hidden" value="{{$today}}" id="dteAbsence">
                                    <input type="hidden" value="{{$period}}" id="period">
                                    <input type="hidden" value="{{$weeks}}" id="types">
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive px-lg-3">
                                    <table id="basic-col-reorder" class="table table-striped table-bordered nowrap" style="margin: auto">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%"></th>
                                                <th class="text-uppercase text-center" style="width: 15%">Matricule</th>
                                                <th class="text-uppercase text-center" style="width: 35%">Nom et prenoms</th>
                                                <th class="text-uppercase text-center" style="width: 15%">Genre</th>
                                                <th class="text-center">{{$period == 1 ? 'Matin':'Après midi'}}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($datas as $item)
                                            <tr>
                                                <th class="text-center py-1">
                                                    <img src="{{ asset($item['sexe'] == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                </th>
                                                <td class="py-2"><div class="mt-2">{{$item['matricule']}}</div></td>
                                                <td class="py-2">
                                                    <div class="mt-2">{{ Str::limit((strtoupper($item['first_name']).' '.ucwords($item['last_name'])), '27', '...') }}</div>
                                                </td>
                                                <td class="py-2"><div class="mt-2">{{ ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin') }}</div></td>
                                                <th class="py-2 text-center">
                                                    <input type="checkbox" class="mt-2 checkbox" value="{{ $item['id'] }}">
                                                </th>
                                            </tr>
                                            @endforeach 
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/AlertifyJS/1.13.1/alertify.min.js"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $("#basic-col-reorder").on('click', '.checkbox', function() {
                $checked = $(this).is(':checked') ? true:false;
                if($(this).val()){
                    $.ajax({
                        url: $checked ? '{{ route('appel.store') }}':'{{ route('appel.notStore') }}',
                        method: 'GET',
                        data: {
                            classed : $('#classId').val(),
                            dateAb : $('#dteAbsence').val(),
                            period : $('#period').val(),
                            week : $('#types').val(),
                            valeur : $(this).val(),
                            type : 'primaire',
                        },
                        success: function(data){
                            if(data == 200){
                                alertify.set('notifier','position', 'top-right');
                                $checked ? alertify.success('Absence pointée.'): alertify.success('Absence annulée.');
                            }
                            else{
                                alertify.set('notifier','position', 'top-right');
                                alertify.error('Une erreur est survenue.');
                            }
                        }
                    });
                }
            })

        })
    </script>
@endsection