<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\TypeEnseignement;
use App\Models\LibelleBilan;
use App\Models\LibelleBilanMatter;
use App\Models\Serie;
use App\Models\Level;
use App\Models\Cutting;
use App\Models\Matter;
use App\Models\PrimaryMatter;
use App\Models\SubMatter;
use App\Models\Coefficient;
use App\Models\WeekDay;
use App\Models\Role;
use App\Models\EvaluationType;
use App\Models\MotifSanction;
use App\Models\LevelPrimaryMatters;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Gzstion dee Role
        Role::create(['role' => 'superAdmin']); // id = 1
        Role::create(['role' => 'admin']); // id = 2
        Role::create(['role' => 'caissiere']); // id = 3
        Role::create(['role' => 'directeur general']); // id = 4
        Role::create(['role' => 'educateur']); // id = 5
        Role::create(['role' => 'enseignant']); // id = 6
        Role::create(['role' => 'directeur']); // id = 7
        Role::create(['role' => 'surveillant']); // id = 8
        
        // User::factory(10)->create();
        User::factory()->create();

        // Type d'enseignement
        TypeEnseignement::create(['type_enseignement' => 'prescolaire']);
        TypeEnseignement::create(['type_enseignement' => 'primaire']);
        TypeEnseignement::create(['type_enseignement' => 'collège']);
        TypeEnseignement::create(['type_enseignement' => 'lycée']);
        TypeEnseignement::create(['type_enseignement' => 'technique']);
        TypeEnseignement::create(['type_enseignement' => 'supérieur']);


        // Libelle Bilan [Generale]
        LibelleBilan::create(['libelle' => 'bilan lettres', 'type' => 'generale']);
        LibelleBilan::create(['libelle' => 'bilan sciences', 'type' => 'generale']);
        LibelleBilan::create(['libelle' => 'bilan autres', 'type' => 'generale']);
        // Unite de Formation [Technique]
        LibelleBilan::create(['libelle' => 'unite de formation pratique', 'type' => 'technique']);
        LibelleBilan::create(['libelle' => 'unite de formation generale', 'type' => 'technique']);
        LibelleBilan::create(['libelle' => 'unite de formation professionnelle', 'type' => 'technique']);
        LibelleBilan::create(['libelle' => 'unite de formation autre', 'type' => 'technique']);
        // Matiere [Superieur]
        LibelleBilan::create(['libelle' => 'matière générales', 'type' => 'superieur']);
        LibelleBilan::create(['libelle' => 'matière professionnelles', 'type' => 'superieur']);
        LibelleBilan::create(['libelle' => 'matière autres', 'type' => 'superieur']);

        
        // Level
        Level::create(['level' => 'petite section', 'code' => 'PS', 'type_enseignement_id' => 1]); // 1
        Level::create(['level' => 'moyenne section', 'code' => 'MS', 'type_enseignement_id' => 1]); // 2
        Level::create(['level' => 'grande section', 'code' => 'GS', 'type_enseignement_id' => 1]); // 3
        Level::create(['level' => 'CP1', 'code' => 'CP1', 'type_enseignement_id' => 2]); // 4
        Level::create(['level' => 'CP2', 'code' => 'CP2', 'type_enseignement_id' => 2]); // 5
        Level::create(['level' => 'CE1', 'code' => 'CE1', 'type_enseignement_id' => 2]); // 6
        Level::create(['level' => 'CE2', 'code' => 'CE2', 'type_enseignement_id' => 2]); // 7
        Level::create(['level' => 'CM1', 'code' => 'CM1', 'type_enseignement_id' => 2]); // 8
        Level::create(['level' => 'CM2', 'code' => 'CM2', 'type_enseignement_id' => 2]); // 9
        Level::create(['level' => 'sixième', 'code' => '6eme', 'type_enseignement_id' => 3]); // 10
        Level::create(['level' => 'cinquième', 'code' => '5eme', 'type_enseignement_id' => 3]); // 11
        Level::create(['level' => 'quatrième', 'code' => '4eme', 'type_enseignement_id' => 3]); // 12
        Level::create(['level' => 'troisième', 'code' => '3eme', 'type_enseignement_id' => 3]); // 13
        Level::create(['level' => 'séconde', 'code' => '2nd', 'type_enseignement_id' => 4]); // 14
        Level::create(['level' => 'première', 'code' => '1ere', 'type_enseignement_id' => 4]); // 15
        Level::create(['level' => 'terminale', 'code' => 'Tle', 'type_enseignement_id' => 4]); // 16
        Level::create(['level' => 'CPU', 'code' => 'CPU', 'type_enseignement_id' => 1]); // 17

        // Serie
        Serie::create(['serie' => 'A', '2nd' => '1', 'type' => 'secondaire']);
        Serie::create(['serie' => 'A1', '1ere' => '1', 'tle' => '1', 'type' => 'secondaire']);
        Serie::create(['serie' => 'A2', '1ere' => '1', 'tle' => '1', 'type' => 'secondaire']);
        Serie::create(['serie' => 'C', '2nd' => '1', '1ere' => '1', 'tle' => '1', 'type' => 'secondaire']);
        Serie::create(['serie' => 'D', '1ere' => '1', 'tle' => '1', 'type' => 'secondaire']);
        Serie::create(['serie' => '1ere Année', 'type' => 'superieur']);
        Serie::create(['serie' => '2eme Année', 'type' => 'superieur']);

        // Gestion des découpages
        Cutting::create(['libelle' => 'trimestre 1', 'end' => 'non']);
        Cutting::create(['libelle' => 'trimestre 2', 'end' => 'non']);
        Cutting::create(['libelle' => 'trimestre 3', 'end' => 'oui']); 
        Cutting::create(['libelle' => 'semestre 1', 'end' => 'non']);
        Cutting::create(['libelle' => 'semestre 2', 'end' => 'oui']);


        // Gestion des matières par defaut
        Matter::create(['libelle' => 'Anglais', 'abbreviated' => 'Ang', 'ministere' => '1']); // id = 1
        Matter::create(['libelle' => 'Français', 'abbreviated' => 'Fr', 'ministere' => '1']); // id = 2
        Matter::create(['libelle' => 'Histoire-Géographie', 'abbreviated' => 'HG', 'ministere' => '1']); // id = 3
        Matter::create(['libelle' => 'Mathématique', 'abbreviated' => 'Maths', 'ministere' => '1']); // id = 4
        Matter::create(['libelle' => 'Physique-chimie', 'abbreviated' => 'PC', 'ministere' => '1']); // id = 5
        Matter::create(['libelle' => 'Sciences de la vie et de la terre', 'abbreviated' => 'SVT', 'ministere' => '1']); // id = 6
        Matter::create(['libelle' => 'Education physique et sportive', 'abbreviated' => 'EPS', 'ministere' => '1']); // id = 7
        Matter::create(['libelle' => 'Espagnol ', 'abbreviated' => 'Esp', 'ministere' => '1']); // id = 8
        Matter::create(['libelle' => 'Allemand ', 'abbreviated' => 'All', 'ministere' => '1']); // id = 9
        Matter::create(['libelle' => 'EDHC', 'abbreviated' => 'EDHC', 'ministere' => '1']); // id = 10
        Matter::create(['libelle' => 'Musique', 'abbreviated' => 'Mus', 'ministere' => '1']); // id = 11
        Matter::create(['libelle' => 'Arts plastique', 'abbreviated' => 'AP', 'ministere' => '1']); // id = 12
        Matter::create(['libelle' => 'Philosophie', 'abbreviated' => 'Philo', 'ministere' => '1']); // id = 13
        Matter::create(['libelle' => 'Mixte', 'abbreviated' => 'All/Esp']); // id = 14
        Matter::create(['libelle' => 'Conduite', 'abbreviated' => 'Cdte']); // id = 15

        // Gestion des matières par defaut Primaire
        PrimaryMatter::create(['libelle' => 'Lecture', 'abbreviated' => 'Lect']); // 1
        PrimaryMatter::create(['libelle' => 'Ecriture', 'abbreviated' => 'Ecrit']); // 2
        PrimaryMatter::create(['libelle' => 'Français (Expression ecrite + Orthographe)', 'abbreviated' => 'Fran']); // 3
        PrimaryMatter::create(['libelle' => 'Dictée', 'abbreviated' => 'Dict']); // 4
        PrimaryMatter::create(['libelle' => 'Dessin', 'abbreviated' => 'Dess']); // 5
        PrimaryMatter::create(['libelle' => 'Poésie/Chant', 'abbreviated' => 'Poe/Cht']); // 6
        PrimaryMatter::create(['libelle' => 'Mathématique', 'abbreviated' => 'Math']); // 7
        PrimaryMatter::create(['libelle' => 'Exploitation de texte', 'abbreviated' => 'Expl Text']); // 8
        PrimaryMatter::create(['libelle' => 'Eveil au milieu', 'abbreviated' => 'Eveil Mil']); // 9
        PrimaryMatter::create(['libelle' => 'Copie', 'abbreviated' => 'Cop']); // 10
        PrimaryMatter::create(['libelle' => 'Expression ecrite', 'abbreviated' => 'Exp E']); // 11
        PrimaryMatter::create(['libelle' => 'EDHC', 'abbreviated' => 'EDHC']); // 12

        // Gestion des sous matieres par defaut
        SubMatter::create(['libelle' => 'Composition Française', 'abbreviated' => 'CF', 'matter_id' => 2]);
        SubMatter::create(['libelle' => 'Orthographe-Grammaire', 'abbreviated' => 'OG', 'matter_id' => 2]);
        SubMatter::create(['libelle' => 'Expression Orale', 'abbreviated' => 'E0', 'matter_id' => 2]);


        // Libelle Bilan Matiere
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 1, 'type' => 'secondaire', 'bilan' => 2]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 2, 'type' => 'secondaire', 'bilan' => 1]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 3, 'type' => 'secondaire', 'bilan' => 3]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 2, 'matter_id' => 4, 'type' => 'secondaire', 'bilan' => 1]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 2, 'matter_id' => 5, 'type' => 'secondaire', 'bilan' => 2]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 2, 'matter_id' => 6, 'type' => 'secondaire', 'bilan' => 3]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 3, 'matter_id' => 7, 'type' => 'secondaire', 'bilan' => 1]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 8, 'type' => 'secondaire', 'bilan' => null]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 9, 'type' => 'secondaire', 'bilan' => null]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 3, 'matter_id' => 10, 'type' => 'secondaire', 'bilan' => 2]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 3, 'matter_id' => 11, 'type' => 'secondaire', 'bilan' => 4]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 3, 'matter_id' => 12, 'type' => 'secondaire', 'bilan' => 4]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 13, 'type' => 'secondaire', 'bilan' => 5]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 1, 'matter_id' => 14, 'type' => 'secondaire', 'bilan' => 4]);
        LibelleBilanMatter::create(['libelle_bilan_id' => 3, 'matter_id' => 15, 'type' => 'secondaire', 'bilan' => 3]); // Conduite pour le Général
        LibelleBilanMatter::create(['libelle_bilan_id' => 7, 'matter_id' => 15, 'type' => 'technique', 'bilan' => 3]); // Conduite pour la Technique
        


        // Association des matières à un niveau pour le primaire
        LevelPrimaryMatters::create(['level_id' => 1, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 1, 'primary_matter_id' => 2, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 1, 'primary_matter_id' => 3, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 1, 'primary_matter_id' => 7, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 1, 'primary_matter_id' => 5, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 1, 'primary_matter_id' => 6, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 2, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 2, 'primary_matter_id' => 2, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 2, 'primary_matter_id' => 3, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 2, 'primary_matter_id' => 7, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 2, 'primary_matter_id' => 5, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 2, 'primary_matter_id' => 6, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 3, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 3, 'primary_matter_id' => 2, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 3, 'primary_matter_id' => 3, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 3, 'primary_matter_id' => 7, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 3, 'primary_matter_id' => 5, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 3, 'primary_matter_id' => 6, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 2, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 10, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 4, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 3, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 7, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 6, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 17, 'primary_matter_id' => 5, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 2, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 10, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 4, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 11, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 12, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 7, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 6, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 4, 'primary_matter_id' => 5, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 2, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 10, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 4, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 11, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 12, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 7, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 6, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 5, 'primary_matter_id' => 5, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 6, 'primary_matter_id' => 8, 'points' => 30]);
        LevelPrimaryMatters::create(['level_id' => 6, 'primary_matter_id' => 9, 'points' => 30]);
        LevelPrimaryMatters::create(['level_id' => 6, 'primary_matter_id' => 7, 'points' => 30]);
        LevelPrimaryMatters::create(['level_id' => 6, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 6, 'primary_matter_id' => 4, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 6, 'primary_matter_id' => 6, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 7, 'primary_matter_id' => 8, 'points' => 30]);
        LevelPrimaryMatters::create(['level_id' => 7, 'primary_matter_id' => 9, 'points' => 30]);
        LevelPrimaryMatters::create(['level_id' => 7, 'primary_matter_id' => 7, 'points' => 30]);
        LevelPrimaryMatters::create(['level_id' => 7, 'primary_matter_id' => 1, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 7, 'primary_matter_id' => 4, 'points' => 10]);
        LevelPrimaryMatters::create(['level_id' => 7, 'primary_matter_id' => 6, 'points' => 10]);

        LevelPrimaryMatters::create(['level_id' => 8, 'primary_matter_id' => 8, 'points' => 50]);
        LevelPrimaryMatters::create(['level_id' => 8, 'primary_matter_id' => 9, 'points' => 50]);
        LevelPrimaryMatters::create(['level_id' => 8, 'primary_matter_id' => 7, 'points' => 50]);
        LevelPrimaryMatters::create(['level_id' => 8, 'primary_matter_id' => 4, 'points' => 20]);

        LevelPrimaryMatters::create(['level_id' => 9, 'primary_matter_id' => 8, 'points' => 50]);
        LevelPrimaryMatters::create(['level_id' => 9, 'primary_matter_id' => 9, 'points' => 50]);
        LevelPrimaryMatters::create(['level_id' => 9, 'primary_matter_id' => 7, 'points' => 50]);
        LevelPrimaryMatters::create(['level_id' => 9, 'primary_matter_id' => 4, 'points' => 20]);

        // Gestion de quelque Coefficient par defaut
        Coefficient::create(['valeur' => 1]);
        Coefficient::create(['valeur' => 2]);
        Coefficient::create(['valeur' => 3]);
        Coefficient::create(['valeur' => 4]);
        Coefficient::create(['valeur' => 5]);
        Coefficient::create(['valeur' => 6]);

        // Gestion des jours de la semains
        WeekDay::create(['day' => 'lundi']);
        WeekDay::create(['day' => 'mardi']);
        WeekDay::create(['day' => 'mercredi']);
        WeekDay::create(['day' => 'jeudi']);
        WeekDay::create(['day' => 'vendredi']);
        WeekDay::create(['day' => 'samedi']);


        // Gestion des types d'evaluations
        EvaluationType::create(['type' => 'Devoir de classe']);
        EvaluationType::create(['type' => 'Devoir de niveau']);
        EvaluationType::create(['type' => 'Intérogation Ecrite']);
        EvaluationType::create(['type' => 'Intérogation Orale']);


        // Gestion des types d'evaluations
        MotifSanction::create(['motif' => 'assiduité et ponctualité', 'valeur' => '0.5', 'total' => 6]);
        MotifSanction::create(['motif' => 'indiscipline', 'valeur' => '1', 'total' => 7]);
        MotifSanction::create(['motif' => 'moralité et intégrité', 'valeur' => '1', 'total' => 4]);
        MotifSanction::create(['motif' => 'tenue et présentation', 'valeur' => '0.5', 'total' => 3]);
        MotifSanction::create(['motif' => 'conseil de discipline', 'valeur' => '0', 'total' => 5]);
    }
}