<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resultat_classe_primaires', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('moyenne');
            $table->string('nbre_classe')->nullable();
            $table->string('nbre_non_classe')->nullable();
            $table->string('nbre_superieur')->nullable()->comment('moyenne superieur ou egal a 5'); 
            $table->string('nbre_inferieur')->nullable()->comment('moyenne inferieur a 5');
            $table->unsignedBigInteger('classe_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('evaluated_level_id');
            $table->foreign('classe_id')->references('id')->on('classes')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('evaluated_level_id')->references('id')->on('evaluated_levels')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resultat_classe_primaires');
    }
};
