<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('recapitulatifs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('total_1_h')->nullable(); // Eleve Garçon Ivoirien
            $table->string('total_2_f')->nullable(); // Eleve Fille Ivoirienne
            $table->string('total_3_h')->nullable(); // Eleve Garçon Africain
            $table->string('total_4_f')->nullable(); // Eleve Fille Africainne
            $table->string('total_5_h')->nullable(); // Eleve Garçon Non-Africain
            $table->string('total_6_f')->nullable(); // Eleve Fille Non-Africain
            $table->string('total_7_h')->nullable(); // Total Eleve Garçon
            $table->string('total_8_f')->nullable(); // Total Eleve Fille
            $table->string('total_h')->nullable(); // Total Eleve Garçon
            $table->string('total_f')->nullable(); // Total Eleve Fille
            $table->enum('order',[1,2,3,4]);
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recapitulatifs');
    }
};
