<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('double_vacations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('col_1')->nullable(); // 6eme
            $table->string('col_2')->nullable(); // 5eme
            $table->string('col_3')->nullable(); // 4eme
            $table->string('col_4')->nullable(); // 3eme
            $table->string('col_5')->nullable(); // 2ndeA
            $table->string('col_6')->nullable(); // 2ndeC
            $table->string('col_7')->nullable(); // 1ereA
            $table->string('col_8')->nullable(); // 1ereC
            $table->string('col_9')->nullable(); // 1ereD
            $table->string('col_10')->nullable(); // TleA
            $table->string('col_11')->nullable(); // TleC
            $table->string('col_12')->nullable(); // TleD
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('double_vacations');
    }
};
