<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('primary_notes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('note');
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('evaluated_level_id');
            $table->unsignedBigInteger('level_primary_matter_id');
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->foreign('evaluated_level_id')->references('id')->on('evaluated_levels')->onDelete('cascade');
            $table->foreign('level_primary_matter_id')->references('id')->on('level_primary_matters')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('primary_notes');
    }
};
