<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('level_primary_matters', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('points');
            $table->unsignedBigInteger('primary_matter_id');
            $table->unsignedBigInteger('level_id');
            $table->enum('status', [0,1])->default(1);
            $table->foreign('primary_matter_id')->references('id')->on('primary_matters')->onDelete('cascade');
            $table->foreign('level_id')->references('id')->on('levels')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('level_primary_matters');
    }
};
