<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evaluations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('notee');
            $table->string('date_create');
            $table->unsignedBigInteger('classe_id');
            $table->unsignedBigInteger('cutting_school_year_id');
            $table->unsignedBigInteger('level_matter_id');
            $table->unsignedBigInteger('sub_matter_id')->nullable();
            $table->unsignedBigInteger('evaluation_type_id');
            $table->enum('status', [0,1])->default(1);
            $table->foreign('classe_id')->references('id')->on('classes')->onDelete('cascade');
            $table->foreign('cutting_school_year_id')->references('id')->on('cutting_school_year')->onDelete('cascade');
            $table->foreign('level_matter_id')->references('id')->on('level_matter')->onDelete('cascade');
            $table->foreign('sub_matter_id')->references('id')->on('sub_matters')->onDelete('cascade');
            $table->foreign('evaluation_type_id')->references('id')->on('evaluation_types')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evaluations');
    }
};
