<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('classes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('libelle');
            $table->integer('effectif');
            $table->integer('inscrits')->default(00);
            $table->enum('lv2',['allemand','espagnol', 'mixte'])->nullable();
            $table->enum('type', ['primaire', 'secondaire', 'technique', 'superieur']);
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->unsignedBigInteger('level_id');
            $table->unsignedBigInteger('serie_id')->nullable();
            $table->enum('letter',['A','B','C','BM'])->nullable();
            $table->enum('additif',['AP','Mus'])->nullable();
            $table->enum('bts',[1,2])->nullable();
            $table->enum('status',[0,1])->default(1);
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->foreign('level_id')->references('id')->on('levels')->onDelete('cascade');
            $table->foreign('serie_id')->references('id')->on('series')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('classes');
    }
};
