<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('matricule')->unique();
            $table->string('first_name');
            $table->string('last_name');
            $table->enum('sexe',['F','M'])->comment('F : Feminin', 'M : Masculin');
            $table->string('date_birth');
            $table->string('place_birth');
            $table->string('place_residence');
            $table->string('first_name_father');
            $table->string('last_name_father');
            $table->string('profession_father');
            $table->string('first_name_mother');
            $table->string('last_name_mother');
            $table->string('profession_mother');
            $table->enum('type',['primaire','secondaire','technique','superieur']);
            $table->string('photo')->nullable();
            $table->enum('status',[0,1])->default(1);
            $table->unsignedBigInteger('nationalitie_id');
            $table->unsignedBigInteger('parent_eleve_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('nationalitie_id')->references('id')->on('nationalities')->onDelete('cascade');
            $table->foreign('parent_eleve_id')->references('id')->on('parent_eleves')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
