<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('address_email')->unique();
            $table->string('phon_school')->unique();
            $table->string('addres_postal')->nullable();
            $table->string('address_iep')->nullable();
            $table->string('school_city')->nullable();
            $table->enum('box',['0', '1'])->default(0);
            $table->enum('transport',['0', '1'])->default(0);
            $table->enum('canteen',['0', '1'])->default(0);
            $table->enum('letter_class',['0', '1'])->default(0);
            $table->enum('musique_aplastique',['0', '1'])->default(0);
            $table->enum('caisse',['0', '1'])->default(0);
            $table->unsignedBigInteger('get_dren_id')->nullable();
            $table->unsignedBigInteger('school_id');
            $table->string('image')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->timestamps();
            $table->foreign('get_dren_id')->references('id')->on('get_drens')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
