<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Student extends Model
{
    protected $guarded = [];

    public function schoolYear(){
        return $this->belongsTo(SchoolYear::class);
    }

    public function parentEleve(){
        return $this->belongsTo(ParentEleve::class);
    }

    public function typeEnseignement(){
        return $this->belongsTo(TypeEnseignement::class);
    }

    public function nationalitie(){
        return $this->belongsTo(Nationality::class);
    }

    public function inscriptions(){
        return $this->hasMany(Inscription::class);
    }

    public function urlStudent(){
        return Storage::url($this->photo);
    }
}
