<?php

namespace App\Listeners;

use App\Models\LevelMatter;
use App\Events\MoyenneMatiereEvent;
use App\Models\MoyenneAnnuelleTrimestre;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class MoyenneMatiereListener
{
    public function handle(MoyenneMatiereEvent $event): void
    {
        $resut = MoyenneAnnuelleTrimestre::where('inscription_id', $event->student)->where('level_matter_id', $event->matiere)->where('school_year_id', $event->year)->first();
        if($resut){
            $val = explode(' ', $event->libelle);
            $resut->update([
                'coeffs' => $event->ceoff,
                'rang_trim' => $event->rang,
                'moyenne_'.$val[1] => $event->moyenne
            ]);
        }
        else{
            MoyenneAnnuelleTrimestre::create([
                'moyenne_1' => $event->moyenne,
                'school_year_id' => $event->year,
                'inscription_id' => $event->student,
                'school_id' => $event->school,
                'level_matter_id' => $event->matiere
            ]); 
        }
    }
}
