<?php

namespace App\Jobs;

use App\Models\ResultatClassePrimaire;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class CalculResultatClassePrimaire implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $class;
    protected $school;
    protected $compo;

    public function __construct($class, $school, $compo)
    {
        $this->class = $class;
        $this->school = $school;
        $this->compo = $compo;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $moyenne = $this->moyenneClasse();
        $classe = $this->nbreStudentClasse();
        $nonClasse = $this->nbreStudentNonClasse();
        $detail = $this->detailResultal();
        $verify = ResultatClassePrimaire::where('classe_id', $this->class)->where('school_id', $this->school)->where('evaluated_level_id', $this->compo)->first();
        if($verify){
            $verify->update([
                'moyenne' => $moyenne,
                'nbre_classe' => $classe,
                'nbre_non_classe' => $nonClasse,
                'nbre_superieur' => $detail['superieur'],
                'nbre_inferieur' => $detail['inferieur']
            ]);
        }
        else{
            ResultatClassePrimaire::create([
                'moyenne' => $moyenne,
                'nbre_classe' => $classe,
                'nbre_non_classe' => $nonClasse,
                'nbre_superieur' => $detail['superieur'],
                'nbre_inferieur' => $detail['inferieur'],
                'evaluated_level_id' => $this->compo,
                'classe_id' => $this->class,
                'school_id' => $this->school
            ]);
        }
    }


    private function moyenneClasse()
    {
        $somme = DB::table('resultat_primaires')
        ->join('inscriptions', 'inscriptions.id', '=', 'resultat_primaires.inscription_id')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('resultat_primaires.evaluated_level_id', $this->compo)
        ->where('resultat_primaires.school_id', $this->school)
        ->where('resultat_primaires.moyenne', '!=', 'nc')
        ->sum('resultat_primaires.moyenne');
        $result = $somme ? round($somme / $this->nbreStudentClasse()):'00';
        return $result;
    }


    private function nbreStudentClasse()
    {
        $nbre = DB::table('resultat_primaires')
        ->join('inscriptions', 'inscriptions.id', '=', 'resultat_primaires.inscription_id')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('resultat_primaires.evaluated_level_id', $this->compo)
        ->where('resultat_primaires.school_id', $this->school)
        ->where('resultat_primaires.moyenne', '!=', 'nc')->count();
        return $nbre;
    }


    private function nbreStudentNonClasse()
    {
        $nbre = DB::table('resultat_primaires')
        ->join('inscriptions', 'inscriptions.id', '=', 'resultat_primaires.inscription_id')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('resultat_primaires.evaluated_level_id', $this->compo)
        ->where('resultat_primaires.school_id', $this->school)
        ->where('resultat_primaires.moyenne', 'nc')->count();
        return $nbre;
    }


    private function detailResultal(){
        $dts = $this->studentGet();
        $nbreMoys = 0; $nbreNonMoys = 0;
        foreach($dts as $item){
            $item->moyenne < 5 ? $nbreNonMoys+=1:$nbreMoys+=1;
        }
        return [
            'superieur' => $nbreMoys,
            'inferieur' => $nbreNonMoys
        ];
    }


    private function studentGet()
    {
        $results = DB::table('resultat_primaires')
        ->join('inscriptions', 'inscriptions.id', '=', 'resultat_primaires.inscription_id')
        ->select('resultat_primaires.moyenne')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('resultat_primaires.evaluated_level_id', $this->compo)
        ->where('resultat_primaires.school_id', $this->school)
        ->where('resultat_primaires.moyenne', '!=', 'nc')->get();
        return $results;
    }
}
