<?php

namespace App\Jobs;

use App\Models\LevelMatter;
use App\Models\CuttingSchoolYear;
use App\Jobs\CalculMoyenneBilanJob;
use App\Jobs\CalculResultatClasseJob;
use App\Jobs\MoyenneAnnuelleMatiereJob;
use App\Models\MoyenneDecoupageMatiere;
use App\Jobs\CalculMoyenneTrimestielleJob;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Bus;
use App\Events\MoyenneMatiereEvent;

class ApprovedMoyenneJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data, $student, $classe, $matiere, $bilan, $cutting, $school;
    /**
     * Create a new job instance.
     */
    public function __construct($data, $student, $classe, $matiere, $bilan, $cutting, $school)
    {
        $this->data = $data;
        $this->student = $student;
        $this->classe = $classe;
        $this->matiere = $matiere;
        $this->bilan = $bilan;
        $this->cutting = $cutting;
        $this->school = $school;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $cutting = CuttingSchoolYear::find($this->cutting);
        foreach($this->data as $item){
            $val = MoyenneDecoupageMatiere::where('inscription_id', $item['id'])->where('level_matter_id', $this->matiere)->where('cutting_school_year_id', $this->cutting)->first();
            if($val){
                $val->update([
                    'moyenne' => $item['moyenne'],
                    'rang' => $item['rang']
                ]);
            }
            else{
                $this->saveDataMoyenne($item['id'], $item['moyenne'], $item['rang']);
            }
            // Déclenchement de l’événement
            event(new MoyenneMatiereEvent($item['id'], $item['moyenne'], $item['rang'], $this->getCoef(), $cutting->school_year_id, $cutting->cutting->libelle, $this->matiere, $this->school));
        }

        // Déclenchement des autres jobs
        Bus::chain([
            new CalculMoyenneTrimestielleJob($this->student, $this->classe, $this->cutting, $this->school),
            new CalculMoyenneBilanJob($this->student, $this->classe, $this->cutting, $this->bilan, $this->school),
            new CalculResultatClasseJob($this->classe, $this->school, $this->cutting)
        ])->dispatch();


        // Déclenchement de Job pour le calcul des moyennes Annuelles .................
        if($cutting->cutting->end == 'oui'){
            MoyenneAnnuelleMatiereJob::dispatch($this->student, $this->matiere, $cutting->school_year_id)->delay(now()->addSeconds(1));
        }
    }


    private function saveDataMoyenne($item, $moyen, $rang)
    {
        MoyenneDecoupageMatiere::create([
            'rang' => $rang,
            'moyenne' => $moyen,
            'inscription_id' => $item,
            'level_matter_id' =>$this->matiere,
            'cutting_school_year_id' => $this->cutting
        ]);
    }


    private function getCoef()
    {
        $val = LevelMatter::find($this->matiere);
        return $val->coefficient->valeur;
    }
}
