<?php

namespace App\Http\Controllers;
use App\Models\Level;
use App\Models\Serie;
use App\Models\SchoolMatter;
use App\Models\LevelMatter;
use App\Models\Coefficient;
use App\Models\Setting;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class GetMatterController extends Controller
{
    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request, string $string)
    {
        try{
            $level = Level::where('id', $request['level'])->first();
            return view('pages.matters.create_get', [
                'valeur' => $string,
                'level' => $level,
                'matters' => $this->schoolMatterLevel(changeVal($string)),
                'serie' => Serie::where('id', $request['serie'])->first() ?? null,
                'coeff' => $level['type_enseignement_id'] > 2 ? true:false
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !',
                'string' => $string
            ]);
        }

    }

    /**
     * searchSerie a newly created resource in storage.
     */
    public function searchSerie(Request $request)
    {
        try{
            $level = Level::where('id', $request['level'])->first();
            if($level['type_enseignement_id'] > 3){
                $data = $this->getSerie($request['string'], $level['code']);
            }
            else{
                $data = 201;   
            }
            
            return response()->json($data);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !',
                'string' => $request['string']
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{ //dd($request);
            $validated = $request->validate([
                'type' => 'required|string',
                'typeId' => 'required|string',
                'matter' => 'required',
                'coef' => 'required',
            ]);
            $typeId = explode('_', $request['typeId']);
            $val = changeVal($validated['type']);
            $matTab = $request['matter'];
            $coefTab = $request['coef'];
            if(sizeof($matTab) == sizeof($coefTab)){
                $this->deleteData($typeId[0], $request['serie'] ?? null); // Delete data end existence
                // if($val == 'secondaire' && $typeId[0] > 11){
                //     $this->classMixteMatter($typeId[0]);
                // }

                if(in_array($val, ['secondaire', 'technique'])){
                    LevelMatter::create([
                        'school_id' => auth()->user()->school_id,
                        'level_id' => $typeId[0],
                        'matter_id' => 15,
                        'coefficient_id' => 1,
                        'serie_id' => $request['serie'] ?? null,
                        'type' => $val
                    ]);
                }
                $exist = 0;
                if($coefTab && sizeof($coefTab) == sizeof($matTab)){
                    for($i = 0; $i < sizeof($coefTab); $i++){
                        $coef = $this->existeCoef($coefTab[$i]);
                        $this->saveData($matTab[$i], $coef, $request['serie'] ?? null, $typeId[0], $val);
                        if($val == 'secondaire' && in_array($matTab[$i], ['8', '9']) && $exist == null){
                            $this->classMixteMatter($typeId[0], $request['serie'] ?? null); $exist++;
                        }
                    }
                }
                elseif(sizeof($matTab) > 0){
                    for($i = 0; $i < sizeof($matTab); $i++){
                        $this->saveData($matTab[$i], 1, $request['serie'] ?? null, $typeId[0], $val);
                    }
                }

                return to_route('matiere.index')->with([
                    'str' => 'success',
                    'msg' => 'Coefficient et matière associés '.$typeId[1],
                    'string' => $validated['type']
                ]);
            }
            
        }
        catch (\Exception $e) {
            return to_route('matiere.index')->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !',
                'string' => $request['type']
            ]);
        }

    }

    /**
     * Remove the specified resource from storage.
     */
    public function search(Request $request)
    {
        try{
            $tab = getIdLevel($request['data']);
            if(sizeof($tab) == 2){
                $dts = Level::where('type_enseignement_id', $tab[0])->Orwhere('type_enseignement_id', $tab[1])->get();
            }
            else{
                $data = Setting::where('school_id',auth()->user()->school_id)->first();
                $dts = $tab[0] == 6 ? $data->school->levels:Level::where('type_enseignement_id', $tab[0])->get();
            }
            
            return response()->json($dts);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    protected function saveData($idMatter, $idCoef = 1, $idSerie = null, $idType, $type)
    {
        LevelMatter::create([
            'school_id' => auth()->user()->school_id,
            'level_id' => $idType,
            'matter_id' => $idMatter,
            'coefficient_id' => $idCoef,
            'serie_id' => $idSerie ?? null,
            'type' => $type
        ]);
    }


    protected function classMixteMatter($level, $serie = null){
        LevelMatter::create([
            'school_id' => auth()->user()->school_id,
            'level_id' => $level,
            'matter_id' => 14,
            'coefficient_id' => 1,
            'serie_id' => $serie ?? null,
            'type' => 'secondaire'
        ]);
    }

    /**
     * Remove the created the coefficient
     */
    protected function existeCoef($val)
    {
        $data = Coefficient::where('valeur', $val)->first();
        if(!$data){
            $data = Coefficient::create(['valeur' => $val]);
        }
        return $data['id']; 
    }

    /**
     * Show the form for editing the specified resource.
     */
    protected function deleteData($level, $serie = null)
    {
        $dts = LevelMatter::where('level_id', $level)->where('serie_id', $serie)->where('school_id', auth()->user()->school_id)->get();
        if(count($dts)){
            foreach($dts as $item){
                $item->delete();
            }
        }
    }

    protected function getSerie($string, $level){
        $vals = $string == "supérieur" ? Serie::where('type', 'superieur')->get():Serie::where('type', changeVal($string))->where(strtolower($level), '1')->get();
        $serie = $string == "supérieur" ? $vals:auth()->user()->school->series->where('type', changeVal($string));
        $tab = [];
        foreach($vals as $val){
            foreach($serie as $item){
                if($val['id'] == $item['id']){
                    $tab[] =  $val;
                }
            }
        }
        return $tab;
    }


    protected function schoolMatterLevel($val){
        $data =  DB::table('matters')
        ->join('school_matter', 'matters.id', '=', 'school_matter.matter_id')
        ->select('matters.id', 'matters.libelle', 'matters.abbreviated', 'school_matter.matter_id')
        ->where('school_matter.school_id', '=', getuserSchoolId())
        ->where('school_matter.type', '=', $val)
        ->where('school_matter.status', '=', '1')
        ->where('school_matter.matter_id', '<>', '15')
        ->orderBy('matters.libelle')
        ->get();

        return json_decode($data, true);
    }
}
