<?php

namespace App\Http\Controllers;

use App\Imports\DrenImport;
use App\Models\GetDren;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class GetDrenController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = GetDren::orderby('libelle', 'ASC')->get();
            return view('pages.dren.index',['drens' => $data]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $request->validate(['files' => 'required|mimes:xlsx']);
            Excel::import(new DrenImport, $request->file('files'));

            return back()->with([
                'str' => 'success',
                'msg' => 'Importation effectuée !'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
