@extends('app')
@section('title', 'Gestion des appels')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Transport</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addModal" title="Add New scolarity Fee"><i class="fas fa-exchange-alt m-0"></i></button>
                                        <a href="{{route('transport.create')}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Gestion des zones"><i class="fas fa-border-all m-0"></i></a>
                                    </span>                                
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($data as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}} menuStep" id="{{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" data-lib="{{$item['libelle']}}" data-toggle="tab" href="#home{{$item['nbre']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ucfirst($item['libelle'])}}
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($data as $item)
                                        <div class="tab-pane {{session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')}}" id="home{{$item['nbre']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Lieux</th>
                                                        <th class="text-center">Montant</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $i = 1; @endphp
                                                    @foreach ($item['data'] as $val)
                                                    <tr>
                                                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                        <td>{{ucwords($val->libelle)}}</td>
                                                        <td class="text-left pl-3">{{ucwords($val->zone)}}</td>
                                                        <td class="text-center">{{formatMontant($val->montant)}} FR CFA</td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <button class="getEdit btn btn-sm btn-info text-white text-center px-2 mr-1" title="Edit" data-id="{{$val->id}}" data-amount="{{$val->montant}}" data-lib="{{ucwords($val->zone)}}" data-toggle="modal" data-target="#editModal"><i class="far fa-edit"></i></button>
                                                                <button class="getDelet btn btn-sm btn-danger text-white text-center px-2 ml-1" title="Delete" data-id="{{$val->id}}" data-zone="{{ucwords($val->libelle)}}" data-lib="{{ucwords($val->zone)}}" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addModalLongTitle">Add Zone</h5>
            <span style="font-size: 17px" id="vals"></span>
        </div>
        <form action="{{route('transport.store')}}" method="post">
            @csrf
            <div class="modal-body py-3">
                <input type="hidden" name="type" id="type">
                <input type="hidden" name="year" value="{{$year['id']}}">
                <div class="form-group pt-2">
                    <label for="zone" class="form-label">Select zone<span class="text-danger">*</span> :</label>
                    <select class="form-control" name="zone" id="zone" aria-label="Default select example">
                        <option selected>Select ...</option>
                        @foreach ($zones as $zone)
                            <option value="{{$zone->id}}">{{ucwords($zone->zone->libelle)}}</option>
                        @endforeach
                    </select>
                </div>
               <div class="form-group pt-2">
                    <label for="amount" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                    <span style="font-size: 11px; color: rgba(94, 94, 94, 0.815)">Ce montant conserne pour un trimestre ou Semestre.</span>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="editModalLongTitle">Edit</h5>
            <span style="font-size: 17px" id="valEdit"></span>
        </div>
        <form action="{{route('transport.edit')}}" method="post">
            @csrf
            <div class="modal-body py-3">
                <input type="hidden" name="id" id="id">
                <div class="form-group pt-2">
                    <label for="zone" class="form-label">Zone concernée<span class="text-danger">*</span> :</label>
                    <input class="form-control" id="libEdit" disabled>
                </div>
               <div class="form-group pt-2">
                    <label for="montant" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="montant" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal Add -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="deleteModalLongTitle">Delete</h5>
            <span style="font-size: 17px" id="valDelete"></span>
        </div>
        <form action="{{route('transport.destroy')}}" method="post">
            @csrf
            <div class="modal-body py-3 text-center">
                <strong id="delete"></strong>
                <p id="libDelete"></p>
                <p>Confirmez le supression.</p>
                <input type="hidden" id="idDelete" name="id">
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <!-- Select2 JS -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $('#amount, #montant').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });


            $('#type').val($("#active").data('lib'));
            $('#vals, #valEdit, #valDelete').text($("#active").data('lib'));
            $('.nav-link').on('click', function() {
                $('#type').val($(this).data('lib'));
                $('#vals, #valEdit, #valDelete').text($(this).data('lib'));
            });


            $('.getEdit').on('click', function() {
                $('#libEdit').val($(this).data('lib'));
                $('#montant').val(formatVal($(this).data('amount')));
                $('#id').val($(this).data('id'));
            });


            $('.getDelet').on('click', function() {
                $('#delete').text($(this).data('zone'));
                $('#libDelete').text($(this).data('lib'));
                $('#idDelete').val($(this).data('id'));
            });


            function formatVal($val){
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }
        })
    </script>
@endsection