<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('moyenne_bilans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('rang');
            $table->string('points');
            $table->string('coeffs');
            $table->string('moyenne');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('libelle_bilan_id');
            $table->unsignedBigInteger('cutting_school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->foreign('libelle_bilan_id')->references('id')->on('libelle_bilans')->onDelete('cascade');
            $table->foreign('cutting_school_year_id')->references('id')->on('cutting_school_year')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('moyenne_bilans');
    }
};
