<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('levels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('level')->unique();
            $table->string('code')->nullable()->unique();
            $table->unsignedBigInteger('type_enseignement_id')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->timestamps();
            $table->foreign('type_enseignement_id')->references('id')->on('type_enseignements')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('levels');
    }
};
