<?php

namespace App\Jobs;

use App\Models\MoyenneTrimestrielle;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class NonClasseeRangTrimestreJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $students, $cutting, $school;
    
    /**
     * Create a new job instance.
     */
    public function __construct($students, $cutting, $school)
    {
        $this->students = $students;
        $this->cutting = $cutting;
        $this->school = $school;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $dts = getClassement($this->getMoyenne());
        foreach($dts as $item){
            MoyenneTrimestrielle::where('inscription_id', $item['id'])->where('cutting_school_year_id', $this->cutting)->where('school_id', $this->school)->update([
                'rang' => $item['rang']
            ]);
        }
    }

    private function getMoyenne()
    {
        $tableau = [];
        foreach($this->students as $item){
            $tableau[] = [
                'id' => $item['id'],
                'sexe' => $item['sexe'],
                'moyen' => $this->moyenne($item['id'])
            ];
        }
        return $tableau;
    }
    

    private function moyenne($item)
    {
        $val = MoyenneTrimestrielle::where('inscription_id', $item)->where('cutting_school_year_id', $this->cutting)->where('school_id', $this->school)->first();
        return $val['moyenne'] ?? 'nc';
    }
}
