<?php $__env->startSection('title','List student'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <h4>Parents - <?php echo e(count($parents) <= 9 ? '0'.count($parents):count($parents)); ?></h4>
                                    <span>
                                        <a href="<?php echo e(route('student.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block my-0">
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table id="key-intergration" class="table table-striped table-bordered nowrap dataTable">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:15px">N°</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Sexe</th>
                                                    <th>Profession</th>
                                                    <th>Téléphone</th>
                                                    <th>Nbre Enfant</th>
                                                    <th>Message</th>
                                                    <th>Status</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                    <td><?php echo e(strtoupper($item->first_name)); ?></td>
                                                    <td><?php echo e(ucwords($item->last_name)); ?></td>
                                                    <td><?php echo e($item->sexe == 'F' ? ucfirst('Femme'):ucfirst('Homme')); ?></td>
                                                    <td><?php echo e(ucwords($item->profession)); ?></td>
                                                    <td><?php echo e($item->telephon1); ?></td>
                                                    <td class="text-center"><?php echo e(count($item->students) <= 9 ? '0'.count($item->students):count($item->students)); ?></td>
                                                    <td class="text-center"><?php echo e($item->messagerie ? 'Oui':'non'); ?></td>
                                                    <td class="text-center"><?php echo e($item->status ? 'Oui':'non'); ?></td>
                                                    <td class="py-1">
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <a href="<?php echo e(route('parent.show',$item->id)); ?>" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-ellipsis-h"></i></a>
                                                            <a href="<?php echo e(route('parent.edit',$item->id)); ?>" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit"></i></a>
                                                            <button class="parentDelete btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="<?php echo e($item->id); ?>" data-toggle="modal" data-target="#modalCenter"><i class="far fa-trash-alt"></i></button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalCenter" tabindex="-1" role="dialog" aria-labelledby="modalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="modalCenterLongTitle">Delete Parent</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <div class="divInfo" id="divInfo"></div>
                    <p class="my-0">
                        <strong>Vous êtes sur le point de faire une suppression définitive.</strong>
                    </p>
                    <span>Cliquez sur le 'Valider' pour achéver l'action.</span>
                </div>
            </div>
            </div>
            <form action="#" method="post" id="formDelete">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('delete'); ?>
                <div class="modal-footer">
                    <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $urls = window.location.href;
            $url = $urls.split('parent');

            // Delete Parent ................................ 
            $(document).on('click', '.parentDelete', function() {
                $('#modalUser, #roleModal').remove();
                $id = $(this).data('id');
                $('#formDelete').attr('action', $url[0]+'parent/destroy/'+$id); 
                $.ajax({
                    url: '<?php echo e(route('parent.search')); ?>',
                    method: 'GET',
                    data: { data: $id},
                    success: function(response){
                        if(response){
                            $('#divInfo').append(
                                '<h5 class="mb-1 mt-2" id="modalUser">'+response['first_name']+' '+response['last_name']+'</h5>'+
                                '<p class="text-muted" id="roleModal"><strong>'+response['profession']+'</strong></p>'
                            );
                            $('div#modalCenter').fadeIn();
                        }
                    }
                });
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/parent/index.blade.php ENDPATH**/ ?>