<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Détail des Appels</h4>
                                    <div class="text-center text-muted"><?php echo e($class['libelle']); ?> - <?php echo e(ucfirst($matter->matter->abbreviated ?? $matter->matter->libelle)); ?></div>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-3" id="getAdd" title="Nouvel Appel" data-toggle="modal" data-target="#addAppelModal"><i class="fas fa-plus m-0"></i></button>
                                        <a href="<?php echo e(route('appel.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-3" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e($item['actif'] == 1 ? 'active':''); ?>" data-lib="<?php echo e($item['libelle']); ?>" id="<?php echo e($item['actif'] == 1 ? 'active':'inactif'); ?>" data-actif="<?php echo e($item['actif']); ?>" data-id="<?php echo e($item['id']); ?>" data-toggle="tab" href="#home<?php echo e($item['id']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e($item['actif'] == 1 ? 'active':''); ?>" id="home<?php echo e($item['id']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center" style="width: 35%">Nom & Prenoms</th>
                                                        <th class="text-center" style="width: 12%">Sexe</th>
                                                        <th class="text-center" style="width: 12%">Matricule</th>
                                                        <th class="text-center" style="width: 10%">Total absence</th>
                                                        <th class="text-center" style="width: 10%">Justifiées</th>
                                                        <th class="text-center" style="width: 10%">Non justifiées</th>
                                                        <th class="text-center" style="width: %">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-left ml-3"><?php echo e($student['name']); ?></td>
                                                        <td class="text-center"><div class="mt-2"><?php echo e(ucfirst($student['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></div></td>
                                                        <td class="text-center"><?php echo e($student['matricule']); ?></td>
                                                        <td class="text-center"><?php echo e($student['nbre_abs'] <= 9 ? '0'.$student['nbre_abs']:$student['nbre_abs']); ?>H</td>
                                                        <td class="text-center"><?php echo e($student['nbre_abs_justif'] <= 9 ? '0'.$student['nbre_abs_justif']:$student['nbre_abs_justif']); ?>H</td>
                                                        <td class="text-center"><?php echo e($student['nbre_abs_injustif'] <= 9 ? '0'.$student['nbre_abs_injustif']:$student['nbre_abs_injustif']); ?>H</td>
                                                        <td style="width: 15%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                
                                                                <a href="<?php echo e(route('appel.edit',$item['id'].'_'.$matter->matter_id.'_'.$student['id'])); ?>" class="editEval btn btn-sm btn-info text-center px-2 ml-2" title="Détails"><i class="fas fa-align-justify m-0"></i></a>
                                                                
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add New Appel -->
<div class="modal fade" id="addAppelModal" tabindex="-1" role="dialog" aria-labelledby="addAppelModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addAppelModalLongTitle">Nouvel Appel</h5>
        </div>
        <form action="<?php echo e(route('appel.create')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('get'); ?>
            <input type="hidden" name="matter" value="<?php echo e($matter->matter_id); ?>">
            <input type="hidden" name="classed" value="<?php echo e($class->id); ?>">
            <input type="hidden" name="cutting" value="" id="idCutting">
            <div class="modal-body">
                <div class="m-b-30 mt-3">
                    <label for="date">Date d'appel<span class="text-danger">*</span> : </label>
                    <input type="date" name="date" class="form-control" id="date">
                </div>

                <div class="m-b-30 mt-3">
                    
                    <span class="mx-3">
                        <input type="radio" name="period" id="monning" value="1">
                        <label for="monning">Matin</label>
                    </span>
                    <span class="mx-3">
                        <input type="radio" name="period" id="afternoow" value="2">
                        <label for="afternoow">Après midi</label>
                    </span>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $actif = $("#active").data('actif');
            if($actif && $actif != 2){
                $('#getAdd').slideDown();
                $('#idCutting').val($('#active').data('id'));
            }
            else{
                $('#getAdd').slideUp();
                $('#idCutting').val();
            }
            $('.nav-link').on('click', function(){
                $actif = $(this).data('actif');
                $actif == 2 ? $('#getAdd').hide():$('#getAdd').slideDown();
                $('#idCutting').val($actif == 2 ? null:$(this).data('id'));
            });


            // Date du jour
            $('#date').val(new Date().toISOString().split('T')[0]);
            $('#date').attr('max', new Date().toISOString().split('T')[0]); // Limiter la date à celle d'aujourd'hui
            let heure = new Date().getHours().toString().padStart(2, '0');
            if(heure <= 12){
                $('#monning').prop('checked', true);
            }
            else{
                $('#afternoow').prop('checked', true);
            }

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/appels/detail.blade.php ENDPATH**/ ?>