<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Autorisation de cours</title>
</head>
<style>
    @page {
        margin: 100px 25px 100px 25px; /* top, right, bottom, left */
    }

    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }


     header {
        position: fixed;
        border-bottom: 1px solid rgb(204, 201, 201);
        top: -80px;
        left: 0px;
        right: 0px;
        height: 50px;
        text-align: center;
        font-size: 18px;
    }

    .watermark {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%) rotate(-50deg);
        font-size: 100px;
        color: rgba(0, 0, 0, 0.05);
        z-index: -1;
        white-space: nowrap;
        pointer-events: none;
    }

    footer {
        position: fixed;
        border-top: 1px solid rgb(204, 201, 201);
        bottom: -60px;
        left: 0px;
        right: 0px;
        height: 50px;
        text-align: center;
        font-size: 12px;
        color: #4d4b4b;
    }
</style>
<body>
    <div class="watermark">FICHE AUTORISATION</div>
    <header style="margin: 15px auto; height: 100px; padding-bottom: 1px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none;text-align: center">
                            <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;"><?php echo e(mb_strtoupper($school->school->name_school)); ?></b><br>
                                    <i style="font-size: 9px"><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></i><br>
                                    
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    <section style="margin: 30px auto;">
        <div style="margin-top: 25px; padding-top: 10%; paddin-bottom: 15px">
            <div style="margin-top: 20px; padding-bottom: 20px">
                <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                    <b>AUTORISATION DES COURS <?php echo e($data->schoolYear->school_year); ?></b>
                </div>
            </div>
            <div style="padding-top: 10%;  margin-top: 5px;">
                <div style="font-size: 17px;">
                    <p style="text-align: center"> Autorisation au cours au titre de l'année 2025-2026 au sein de l'etablissement.</p>
                    <div style="padding-left: 10%">
                       <p> Matricule : <b><?php echo e(mb_strtoupper($data->student->matricule)); ?></b></p>
                        <p>Nom Et Prénoms : <b><?php echo e(mb_strtoupper($data->student->first_name).' '.ucwords($data->student->last_name)); ?></b></p>
                        <p>Genre : <b><?php echo e(ucfirst($data->student->sexe == 'F' ? 'Féminin':'Masculin')); ?></b></p>
                        <p>Né<?php echo e($data->student->sexe == 'F' ? 'e':''); ?> le : <b><?php echo e(date('d/m/Y', strtotime($data->student->date_birth)).' à '.$data->student->place_birth); ?></b></p>
                        <p>Classe : <b><?php echo e($data->classe->libelle); ?></b></p>
                    
                        <p>Inscrit<?php echo e($data->student->sexe == 'F' ? 'e':''); ?> le <b><?php echo e(date('d/m/Y', strtotime($data->created_at))); ?></b></p>
                    </div>
                </div>
                <div style="float: right; margin-top: 20%">
                    Directeur Des Etudes
                </div>
            </div>
        </div>
    </section>
    <footer class="footer">
        <div style="display: flex; flex-wrap: wrap; justify-content: space-between;">
            <span><?php echo e(mb_strtoupper($school->school->name_school)); ?></span>
            <span>©<?php echo e($data->schoolYear->school_year); ?></span>
            <span><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></span>
        </div>
    </footer>
</body>
</html><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pdf/autorisation.blade.php ENDPATH**/ ?>