<?php $__env->startSection('title', 'Add note'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/alertify.min.css"/>
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/themes/default.min.css"/>
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <form action="<?php echo e(route('evaluation.update',$evaluation->id)); ?>" method="post" id="myForm">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <input type="hidden" name="evalId" id="evalId" value="<?php echo e($evaluation->id); ?>">
                                <div class="card-header mb-0 pb-0">
                                    <div class="d-flex justify-content-between">
                                        <h4>Liste notes - 
                                            <strong style="font-size: 19px">
                                                <?php echo e(ucfirst($evaluation->levelMatter->matter->abbreviated ?? $evaluation->levelMatter->matter->libelle)); ?>

                                                <?php echo e($evaluation->sub_matter_id ? ' ['.$evaluation->subMatter->abbreviated.']':''); ?>

                                            </strong>
                                        </h4>
                                        <span class="form-control-variant" style="font-size: 15px">
                                            <strong class="mr-2"><?php echo e(ucfirst($evaluation->evaluationType->type)); ?> du <?php echo e(date('d/m/Y', strtotime($evaluation['date_create']))); ?></strong>
                                        </span>
                                        <div>
                                            <label id="btnSubmit" style="display: none">
                                                <input type="checkbox" id="checkBox" class="mx-2 my-2" title="Individual validate">
                                                <button id="btnValids" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-1" title="Valider" data-toggle="modal" data-target="#validModal"><i class="fab fa-vaadin mx-0"></i></button>
                                            </label>
                                            <?php if(count($students) > 0): ?>
                                                <?php if(!$approved): ?>
                                                    <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Edit note" id="btnEdit"><i class="fas fa-edit m-0"></i></a>
                                                <?php endif; ?>
                                                <a href="#" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-1" title="Download pdf"><i class="fas fa-download mx-0"></i></a>
                                            <?php else: ?>
                                            <a href="<?php echo e(route('evaluation.create',$evaluation->id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-1" title="Add New Not"><i class="material-icons m-0" style="font-size: 11px">&#xe39d;</i></a>
                                            <?php endif; ?>
                                            <a href="<?php echo e(route('evaluation.return', $evaluation->classe_id.'_'.$evaluation->level_matter_id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </div>
                                    </div>
                                </div>
                                <hr class="mx-3 my-0">
                                <div class="card-block">
                                    <div class="dt-responsive table-responsive px-lg-3">
                                        <table id="saving-reorder" class="table table-bordered"  style="width: 100%">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width: 5%">N°</th>
                                                    <th class="text-uppercase text-center" style="width: 70px">Nom</th>
                                                    <th class="text-uppercase text-center" style="width: 100px">Prénoms</th>
                                                    <th class="text-uppercase text-center" style="width: 10px">Genre</th>
                                                    <th class="text-uppercase text-center" style="width: 20px">Matricule</th>
                                                    <th class="text-center text-uppercase" style="width: 30px">Note</th>
                                                    <th class="text-center tabCheck" style="width: 3%; display: none"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="py-0">
                                                    <th class="text-center py-0">
                                                        <div class="mt-2"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></div>
                                                    </th>
                                                    <td class="py-0"><div class="mt-2"><?php echo e(strtoupper($student->first_name)); ?></div></td>
                                                    <td class="py-0"><div class="mt-2"><?php echo e(ucwords($student->last_name)); ?></div></td>
                                                    <td class="py-0 text-center"><div class="mt-2"><?php echo e(ucfirst($student->sexe == 'F' ? 'Féminin':'Masculin')); ?></div></td>
                                                    <td class="py-0 text-center"><div class="mt-2"><?php echo e($student->matricule); ?></div></td>
                                                    <td class="text-center p-0">
                                                        <span class="d-flex mx-0">
                                                            <input type="hidden" name="student[]" id="student_<?php echo e($i-1); ?>" value="<?php echo e($student->id); ?>">
                                                            <input type="text" name="note[]" id="note_<?php echo e($i-1); ?>" class="form-control mx-0 my-0 text-center myInput" value="<?php echo e($student->note); ?>" data-vals="<?php echo e($evaluation['notee'] * 20); ?>" maxlength="5" placeholder="---" style="width: 60%; font-weight: 600; border:none">
                                                            <strong class="mx-0 mt-2" style="font-size: 17px; font-weight: 500;">/ <?php echo e($evaluation['notee'] * 20); ?></strong>
                                                        </span>
                                                    </td>
                                                    <th class="text-center tabCheck" style="display: none">
                                                        <input type="checkbox" name="" id="" class="checkSave" value="<?php echo e($i-1); ?>" title="Cochez pour enregistrer">
                                                    </th>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Delete Evaluation-->
<div class="modal fade" id="validModal" tabindex="-1" role="dialog" aria-labelledby="validModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="validModalLongTitle">Confirmed</h5>
                <h5 style="font-style: 17px"><?php echo e(date('d/m/Y', strtotime($evaluation['date_create']))); ?></h5>
            </div>
            <div class="modal-body py-3 text-center">
                <strong style="font-size: 16px">Modification des notes </br> <?php echo e($evaluation->levelMatter->matter->libelle); ?></strong>
                <p class="text-center">Voulez-vous vraiment Valider ?</p>
            </div>
            <div class="modal-footer mt-1">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" id="submit1" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/AlertifyJS/1.13.1/alertify.min.js"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            let table = $('#saving-reorder').DataTable();

            $('.myInput').keyup(function() {
                if($(this).val() > $(this).data('vals')){
                    $(this).val(null);
                }
            });

            // Autoriser les touches numériques (0-9) et la touche backspace (code 8)
            $('.myInput').on('keypress', function(e) {
                var key = e.which || e.keyCode;
                if ((key >= 48 && key <= 57) || key === 8 || key === 46 || key === 127) {
                    return true;
                } else {
                    e.preventDefault();
                }
            });

            
            $('#btnEdit').on('click', function(){
                $('#btnSubmit').css('display', '');
                $(this).slideUp();
                $('.myInput').css('border','1px #000 dashed');
            });


            $('#checkBox').click(function(){
                if($(this).is(":checked")){
                    $('#btnValids').slideUp();
                    $('.tabCheck').slideDown();
                }
                else if($(this).is(":not(:checked)")){
                    $('#btnValids').slideDown();
                    $('.tabCheck').slideUp();
                }
            });


            // Save data for ajax .....................
            $('.checkSave').on('click', function() {
                if($(this).val()){
                    $val = $(this).val();
                    $.ajax({
                        url: '<?php echo e(route('evaluation.ajaxUpdate')); ?>',
                        method: 'GET',
                        data: {
                            student: $('#student_'+$val).val(),
                            note: $('#note_'+$val).val(),
                            evalId: $('#evalId').val()
                        },
                        success: function(data){
                            if(data == 1){
                                alertify.set('notifier','position', 'top-right');
                                alertify.success('Mise à jour effectuée');
                            }
                            else{
                                alertify.set('notifier','position', 'top-right');
                                alertify.error('Une erreur est survenue.');
                            }
                        }
                    });   
                }
            });


            $('#btnValids').on('click', function(e) {
                e.preventDefault(); // Empêche l'envoi par défaut
            });

            $('#submit1').click(function(){
                // Rendre tous les éléments visibles temporairement pour que les champs soient inclus dans le formulaire
                table.rows().every(function(rowIdx, tableLoop, rowLoop) {
                    var row = this.node();
                    if (!$(row).is(':visible')) {
                        $(row).find('input, select, textarea').each(function() {
                            var name = $(this).attr('name');
                            var value = $(this).val();
                            $('<input>').attr({
                                type: 'hidden',
                                name: name,
                                value: value
                            }).appendTo('#myForm');
                        });
                    }
                });

                // Soumet le formulaire
                $('#myForm').submit();
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/evaluations/edit.blade.php ENDPATH**/ ?>