<?php $__env->startSection('title', 'Evaluation par matière'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4><?php echo e(ucwords($evaluated->evaluated->libelle)); ?></h4>
                                    <span class="form-control-variant" style="font-size: 17px">
                                        <strong class="mr-2"><?php echo e($classe->libelle); ?></strong>
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Loading file" data-toggle="modal" data-target="#fileModal"><i class="fas fa-ellipsis-h mx-0"></i></button>
                                        <a href="<?php echo e(route('evaluation.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-2">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="saving-reorder" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 3%">N°</th>
                                                <th class="text-center" style="width: 20%">Nom & Prénoms</th>
                                                <th class="text-center" style="width: 5%">Sexe</th>
                                                <?php $__currentLoopData = $matters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th class="text-center" title="<?php echo e($matter->primary_matter->libelle); ?>"><?php echo e($matter->primary_matter->abbreviated); ?></th>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <th class="text-center" style="width: 8%" title="Point obtenu">Point</th>
                                                <th class="text-center" style="width: 8%" title="Moyenne">Moyen</th>
                                                <th class="text-center" style="width: 8%" title="Rang">Rang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                <td class="text-left ml-2"><?php echo e($item['name']); ?></td>
                                                <td class="text-center"><?php echo e($item['sexe']); ?></td>
                                                <?php $__currentLoopData = $item['notes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <td class="text-center"><?php echo e(($note['note']['note'] ?? '---').' / '.$note['valeur']); ?></td>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <td class="text-center"><?php echo e(($item['resultat']['point'] ?? '---').' / '.calculTotatPoint($item['notes'])); ?></td>
                                                <td class="text-center"><?php echo e(($item['resultat']['moyenne'] ?? '---').' / 10'); ?></td>
                                                <td class="text-center"><?php echo e($item['resultat']['rang'] ?? '---'); ?></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="fileModal" tabindex="-1" role="dialog" aria-labelledby="fileModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="fileModalLongTitle">Importion fiche de note</h5>
        </div>
        <form action="<?php echo e(route('composition.import')); ?>"method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="m-b-30">
                    <span class="d-flex justify-content-between mb-2">
                        <label for="files">Importer la fiche<span class="text-danger">*</span> : </label>
                        <a href="<?php echo e(route('composition.file',$evaluated->evaluated->id.'_'.$classe->id)); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Download file"><i class="fas fa-download mx-0"></i> </a>
                    </span>
                    <input type="file" name="files" id="files" class="form-control" placeholder="Importer le fichier format Excel">
                </div>
                <input type="hidden" name="class" value="<?php echo e($classe->id); ?>">
                <input type="hidden" name="evaluated" value="<?php echo e($evaluated->evaluated->id); ?>">
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){


        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/composition/index.blade.php ENDPATH**/ ?>