<?php $__env->startSection('title', 'Add new student'); ?>
<?php $__env->startSection('link'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/select2/dist/css/select2.min.css')); ?>"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="card">
                    <div class="card-header mb-0 pb-0">
                        <div class="d-flex justify-content-between pb-2">                        
                            <h4><?php echo e($data ? 'Edition d\'élève':'Ajout de nouvel élève'); ?></h4>
                            <span class="m-0 p-0 text-center">
                                Les champ avec asterisk (<code>*</code>) sont obligatoires. <br>
                            </span>
                            <span>
                                <a href="<?php echo e(route($data ? 'student.index':'inscription.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply m-0"></i></a>
                            </span>
                        </div>
                    </div>
                    <hr class="my-0 mx-3">
                    <div class="card-block mt-3 text-center">
                        <strong class="text-danger" id="getExist" style="display: none">Vous utilisez un matricule déjà présent !</strong>
                        <form action="<?php echo e(route($data ? 'student.update':'student.store', $data ? $data->id:null)); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field($data ? 'put':'post'); ?>
                            <?php if(!$data): ?>
                            <input type="hidden" value="<?php echo e($idParent); ?>" name="idParent">
                            <input type="hidden" value="<?php echo e($year->id); ?>" name="idYear">
                            <?php endif; ?>
                            <div class="row mb-2" style="display: <?php echo e($data ? 'none':'block'); ?>">
                                <div class="col-12">
                                    <div class="text-left">
                                        <label class="col-form-label text-left" for="type">Type d'enseignement<span class="text-danger">*</span> :</label>
                                        <?php $j = 0; ?>
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="ml-3 my-0">
                                            <input type="radio" class="type" name="type" value="<?php echo e($item['type']); ?>" id="<?php echo e($item['type']); ?>" <?php echo e(old('type') == $item['type'] ? 'checked':($j == 0 ? 'checked':'')); ?> <?php echo e($data ? 'disabled':''); ?>>
                                            <label class="col-form-label m-1" for="<?php echo e($item['type']); ?>"><?php echo e(ucfirst($item['libelle'])); ?></label>
                                        </span>
                                        <?php $j++ ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="text-left">
                                        <span class="mr-3">Type d'apprenant au sien de l'établissement :</span>
                                        <span class="mr-2">
                                            <input type="radio" name="typeStud" id="ancient" value="1" <?php echo e(old('typeStud') == '1' ? 'checked':'checked'); ?>> 
                                            <label for="ancient">Ancien</label>
                                        </span>
                                        <span class="mr-2">
                                            <input type="radio" name="typeStud" id="new" value="0" <?php echo e(old('typeStud') == '0' ? 'checked':''); ?>>
                                            <label for="new">Nouvel</label>
                                        </span>
                                    </div>
                                </div> 
                            </div>
                            
                            <div class="row mb-0 text-left">
                                <div class="col-md-4 mb-2" id="divMatricule">
                                    <div class="form-group">
                                        <label class="col-form-label" for="matricule">Matricule Elève<span class="text-danger">*</span> :</label>
                                        <input type="text" name="matricule" id="matricule" class="form-control <?php $__errorArgs = ['matricule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('matricule', $data ? $data->matricule:null)); ?>" placeholder="Entrez le matricule de l'élève" <?php echo e($data ? ($data['type'] == 'primaire' ? 'disabled':''):''); ?>>
                                        <?php $__errorArgs = ['matricule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nom">Nom Elève<span class="text-danger">*</span> :</label>
                                        <input type="text" name="nom" id="nom" class="form-control <?php $__errorArgs = ['nom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nom', $data ? $data->first_name:null)); ?>" placeholder="Entrez le nom de l'élève">
                                        <?php $__errorArgs = ['nom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="prenom">Prénoms Elève<span class="text-danger">*</span> :</label>
                                        <input type="text" name="prenom" id="prenom" class="form-control <?php $__errorArgs = ['prenom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('prenom', $data ? $data->last_name:null)); ?>" placeholder="Entrez le prénoms de l'élève">
                                        <?php $__errorArgs = ['prenom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="sexe">Genre<span class="text-danger">*</span> :</label><br>
                                        <span class="mr-3">
                                            <input type="radio" name="sexe" id="feminin" value="F" <?php echo e(old('sexe') == 'F' ? 'checked':null); ?> <?php echo e($data ? ($data->sexe == 'F' ? 'checked':null):null); ?>>
                                            <label class="col-form-label m-1" for="feminin">Féminin</label>
                                        </span>
                                        <span class="ml-3">
                                            <input type="radio" name="sexe" id="masculin" value="M" <?php echo e(old('sexe') == 'M' ? 'checked':null); ?> <?php echo e($data ? ($data->sexe == 'M' ? 'checked':null):'checked'); ?>>
                                            <label class="col-form-label m-1" for="masculin">Masculin</label>
                                        </span><br>
                                        <?php $__errorArgs = ['sexe'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="dateNais">Date de naissance<span class="text-danger">*</span> :</label>
                                        <input type="text" name="dateNais" id="dateNais" class="form-control bg-white <?php $__errorArgs = ['dateNais'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('dateNais', $data ? $data->date_birth:null)); ?>" placeholder="Entrez la date de naissance">
                                        <?php $__errorArgs = ['dateNais'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="lieuNais">Lieu de naissance<span class="text-danger">*</span> :</label>
                                        <input type="text" name="lieuNais" id="lieuNais" class="form-control <?php $__errorArgs = ['lieuNais'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('lieuNais', $data ? $data->place_birth:null)); ?>" placeholder="Entrez le lieu de naissance">
                                        <?php $__errorArgs = ['lieuNais'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nationalite">Nationalité<span class="text-danger">*</span> :</label><br>
                                        <select name="nationalite" id="nationalite" class="form-control select2 bg-white <?php $__errorArgs = ['nationalite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Selectionner la nationalité</option>
                                            <?php $__currentLoopData = $nationality; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item['id']); ?>" <?php echo e(old('nationalite') == $item['id'] ? 'selected':null); ?> <?php echo e($data ? ($data->nationalitie_id == $item['id'] ?'selected':null):null); ?>><?php echo e(ucfirst($item['libelle'])); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select><br>
                                        <?php $__errorArgs = ['nationalite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="col-form-label" for="residence">Lieu de résidence<span class="text-danger">*</span> :</label>
                                        <input type="text" name="residence" id="residence" class="form-control <?php $__errorArgs = ['residence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('residence', $data ? $data->place_residence:null)); ?>" placeholder="Entrez le lieu de résidence">
                                        <?php $__errorArgs = ['residence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="col-form-label" for="photo">La photo de l'élève :</label>
                                        <input type="file" name="photo" id="photo" class="form-control">
                                        <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-0 text-left">
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="NomPere">Nom du père biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="NomPere" id="NomPere" class="form-control <?php $__errorArgs = ['NomPere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('NomPere', $data ? $data->first_name_father:($parent ? ($parent['sexe'] == 'H' ? $parent['first_name'] :null):null))); ?>" placeholder="Entrez le nom du père biologie de l'élève">
                                        <?php $__errorArgs = ['NomPere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="prenomPere">Prénoms du père biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="prenomPere" id="prenomPere" class="form-control <?php $__errorArgs = ['prenomPere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('prenomPere', $data ? $data->last_name_father:($parent ? ($parent['sexe'] == 'H' ? $parent['last_name'] :null):null))); ?>" placeholder="Entrez le prénoms du père biologie de l'élève">
                                        <?php $__errorArgs = ['prenomPere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="profPere">Profession du père biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="profPere" id="profPere" class="form-control <?php $__errorArgs = ['profPere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('profPere', $data ? $data->profession_father:($parent ? ($parent['sexe'] == 'H' ? $parent['profession'] :null):null))); ?>" placeholder="Entrez la profession du père biologie de l'élève">
                                        <?php $__errorArgs = ['profPere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="NomMere">Nom de la mère biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="NomMere" id="NomMere" class="form-control <?php $__errorArgs = ['NomMere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('NomMere', $data ? $data->first_name_mother:($parent ? ($parent['sexe'] == 'F' ? $parent['first_name'] :null):null))); ?>" placeholder="Entrez le nom de la mère biologie de l'élève">
                                        <?php $__errorArgs = ['NomMere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="prenomMere">Prénoms de la mère biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="prenomMere" id="prenomMere" class="form-control <?php $__errorArgs = ['prenomMere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('prenomMere', $data ? $data->last_name_mother:($parent ? ($parent['sexe'] == 'F' ? $parent['last_name'] :null):null))); ?>" placeholder="Entrez le prénoms de la mère biologie de l'élève">
                                        <?php $__errorArgs = ['prenomMere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="profMere">Profession de la mère biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="profMere" id="profMere" class="form-control <?php $__errorArgs = ['profMere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('profMere', $data ? $data->profession_mother:($parent ? ($parent['sexe'] == 'F' ? $parent['profession'] :null):null))); ?>" placeholder="Entrez la profession de la mère biologie de l'élève">
                                        <?php $__errorArgs = ['profMere'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-bar text-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row text-left" id="detaiStudent" style="display: none">
                                <hr class="my-3 mx-3 w-100 text-center">
                                <div class="col-12">
                                    <p style="font-size:18px; font-weight: bold; text-decoration: underline;">Année scolaire <?php echo e($year->school_year); ?></p>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divAffecte">
                                    <label>Affectué(e) :</label><br>
                                    <span class="mr-2">
                                        <input type="radio" name="affecte" id="AffOui" value="oui">
                                        <label for="oui">Oui</label>
                                    </span>
                                    <span class="mr-2">
                                        <input type="radio" name="affecte" id="AffNon" value="non">
                                        <label for="non">Non</label>
                                    </span>
                                </div>
                                <div class="col-12 col-md-4 mb-3">
                                    <label>Redoublant(e) :</label><br>
                                    <span class="mr-2">
                                        <input type="radio" name="redoublant" id="RedoubOui" value="oui">
                                        <label for="oui">Oui</label>
                                    </span>
                                    <span class="mr-2">
                                        <input type="radio" name="redoublant" id="RedoubNon" value="non" checked>
                                        <label for="non">Non</label>
                                    </span>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divBoursier">
                                    <label>Boursier(e) :</label><br>
                                    <span class="mr-2">
                                        <input type="radio" name="boursier" id="BoursOui" value="oui">
                                        <label for="oui">Oui</label>
                                    </span>
                                    <span class="mr-2">
                                        <input type="radio" name="boursier" id="BoursNon" value="non">
                                        <label for="non">Non</label>
                                    </span>
                                </div> 
                                <div class="col-12 col-md-4 mb-3">
                                    <div class="form-group mb-3">
                                        <label for="level" class="form-label">Niveau<span class="text-danger">*</span> :</label><br>
                                        <select name="level" id="level" class="form-control select2 bg-white">
                                            <option value="">Selection one option</option>
                                        </select>                                       
                                    </div>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divSerie" style="display: none">
                                    <div class="form-group mb-3">
                                        <label for="serie" class="form-label"><span id="bockSerie"></span><span class="text-danger">*</span> :</label><br>
                                        <select name="serie" id="serie" class="form-control select2 bg-white">
                                            <option value="">Selection one option</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-4" id="divLv2" style="display: none">
                                    <label>LV2 (Langue Vivante 2) :</label><br>
                                    <span class="mx-2" title="Allemand">
                                        <input type="radio" class="lv2" name="lv2" value="allemand" id="lv2All">
                                        <label for="lv2All">All</label>
                                    </span>
                                    <span class="mx-2" title="Espagnol">
                                        <input type="radio" class="lv2" name="lv2" value="espagnol" id="lv2Esp">
                                        <label for="lv2Esp">Esp</label>
                                    </span>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divClasse">
                                    <div class="form-group mb-3">
                                        <label for="classe" class="form-label">Classe<span class="text-danger">*</span> :</label><br>
                                        <select name="classe my-0" id="classe" class="form-control select bg-white">
                                            
                                        </select><br>
                                        <span class="getClass text-danger my-0" id="indispoClass" style="display: none"> Classe non disponible !</option>
                                    </div>
                                </div>
                            </div>

                            <div style="display: <?php echo e($data ? 'block':'none'); ?>">
                                <span class="mx-3" title="<?php echo e($data ? ($data->status ? 'Actif':'Inactif'):null); ?>">
                                    <input type="checkbox" name="status" id="status" value="1" <?php echo e($data ? ($data->status ? 'checked':null):null); ?>>
                                    <label for="status" class="mx-1 form-control-variant">Status</label>
                                </span>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"><i class="fas fa-check-circle"></i> Valider les informations</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/fr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
<script>
    $(document).ready(function(){
        // Verifie si le matricule existent déjà
        $('#matricule').on('change', function(){
            let val = $(this).val();
            if(val){
                $.ajax({
                    url: '<?php echo e(route('student.search')); ?>',
                    method: 'GET',
                    data: {
                        data: val
                    },
                    success: function(response){
                        if(response == 200){
                            $('#getExist').slideDown();
                        }
                        else{
                            $('#getExist').slideUp();
                        }
                    
                    },
                });
            }
        });

        $type = $('input[name="type"]:checked').val();
        if($type){
            getViewEndType($type);
        }

        // value get type enseignement
        $('.type').on('change', function(){
            getViewEndType($(this).val());
        });


        // value get level
        $('#level').on('change', function(){
            $('.valSerie').remove();$('#indispoClass').slideUp();
            $('.valClasse').remove();
            let val = $(this).val().split('_');
            if((val[0] > 13) && (val[0] != 17)){
                $('#divSerie').slideDown();$('select[name="serie"]').removeAttr('disabled');
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                $("#libSerie").remove();
                $("input[name='type']:checked").prop("value") != 'superieur' ? $('#bockSerie').append('<span id="libSerie">Serie</span>'):$('#bockSerie').append('<span id="libSerie">Niveau</span>');
                $.ajax({
                    url: '<?php echo e(route('inscription.serie')); ?>',
                    method: 'GET',
                    data: {
                        libelle: val[1],
                        level: $("input[name='type']:checked").prop("value")
                    },
                    success: function(data){
                        $i = 0;
                        while($i < data.length){
                            $('#serie').append('<option value="'+data[$i].id+'_'+data[$i].serie+'" class="valSerie">'+data[$i].serie+'</option>');
                            $i++;
                        }
                    }
                });
            }
            else if((val[0] > 11) &&( val[0] != 17)){
                $('#divSerie').slideUp();$('select[name="serie"]').attr('disabled', 'disabled');
                $('#divLv2').slideDown();$('#lv2All').prop("checked", true);
                if($("input[name='lv2']:checked").prop("value")){
                    $('.valClasse').remove();
                    getClasseLv2(val[0], $("input[name='lv2']:checked").prop("value"));
                }
            }
            else if((val[0] < 12) || (val[0] == 17)){
                $('#divSerie').slideUp();$('select[name="serie"]').attr('disabled', 'disabled');
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                getClasseNonSerie(val[0]);
            }
        });


        $('#serie').on('change', function() {
            $val = $(this).val().split('_');
            let lvl = $('#level').val().split('_');
            if($val[1] == "A" || $val[1] == "A1" || $val[1] == "A2" || (($val[1] == "C") && (lvl[0] == 14))){
                $('#divLv2').slideDown();$('#lv2All').prop("checked", true);
                $('.valClasse').remove();
                getClasseLv2Serie(lvl[0], $("input[name='lv2']:checked").prop("value"),$val[0]);
            }
            else{
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                getClasseLv2Serie(lvl[0],null,$val[0]);
            }
        });
        
        
        $('.lv2').on('change', function() {
            if($("input[name='lv2']:checked").prop("value")){
                let val = $('#level').val().split('_');
                $('.valClasse').remove();
                getClasseLv2(val[0], $("input[name='lv2']:checked").prop("value"));
            }
        });


        // Initialiser le date picker sur le champ avec l'ID 'datepicker'
        flatpickr("#dateNais", {
            locale: "fr",  // Utilise le français pour l'affichage
            dateFormat: "d-m-Y", // Format de la date
            altInput: true, // Afficher un format alternatif de la date
            altFormat: "d-m-Y", // Format alternatif pour afficher la date
        });

        // add select2
        $('.select2').select2();



        function getViewEndType($vals){
            $('#detaiStudent').slideDown(); $('#indispoClass').slideUp();
            $('.valSerie').remove();
            $('.valClasse').remove();
            if($.inArray($vals, ['Prescolaire', 'Primaire', 'Prescolaire - Primaire'])){
                $('#divAffecte,#divBoursier,#divSerie').slideUp();
                $("#AffOui").prop("checked", false);
                $('#BoursNon').prop("checked", false);
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                $('select[name="serie"]').attr('disabled', 'disabled');
            }
            else{
                $('#divAffecte,#divBoursier').slideDown();
                $("#AffOui").prop("checked", true);
                $('#BoursNon').prop("checked", true);
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                $('select[name="serie"]').attr('disabled', 'disabled');
            }

            // Recuperation des nivaux selon le type d'enseignement choisit
            $.ajax({
                url: '<?php echo e(route('inscription.level')); ?>',
                method: 'GET',
                data: {
                    libelle: $vals
                },
                success: function(data){
                    $('.valLevel').remove();
                    $i = 0;
                    while($i < data.length){
                        $('#level').append('<option value="'+data[$i].id+'_'+data[$i].code+'" class="valLevel">'+data[$i].code+'</option>');
                        $i++;
                    }
                }
            });
        }


        function getClasseNonSerie($id){
            $.ajax({
                url: '<?php echo e(route('inscription.classe')); ?>',
                method: 'GET',
                data: {
                    id: $id,
                    lv2: null,
                    serie: null
                },
                success: function(data){
                    $('.valClasse').remove();
                    if(data.length){
                        $('#indispoClass').slideUp();
                        $i = 0;
                        while($i < data.length){
                            $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                            $i++;
                        }
                    }
                    else{
                       // $('#indispoClass').slideDown()
                        $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                    }
                    
                }
            });
        }


        function getClasseLv2($id, $lv2){
            $.ajax({
                url: '<?php echo e(route('inscription.classe')); ?>',
                method: 'GET',
                data: {
                    id: $id,
                    lv2: $lv2,
                    serie: null
                },
                success: function(data){
                    $('.valClasse').remove();
                    if(data.length){
                        $('#indispoClass').slideUp();
                        $i = 0;
                        while($i < data.length){
                            $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                            $i++;
                        }
                    }
                    else{
                        //$('#indispoClass').slideDown()
                        $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                    }
                    
                }
            });
        }


        function getClasseLv2Serie($id, $lv2 = null, $serie = null){
            $.ajax({
                url: '<?php echo e(route('inscription.classe')); ?>',
                method: 'GET',
                data: {
                    id: $id,
                    lv2: $lv2 ?? null,
                    serie: $serie ?? null
                },
                success: function(data){
                    $('.valClasse').remove();
                    if(data.length){
                        $('#indispoClass').slideUp();
                        $i = 0;
                        while($i < data.length){
                            $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                            $i++;
                        }
                    }
                    else{
                       // $('#indispoClass').slideDown()
                        $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                    }
                    
                }
            });
        }
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/student/create.blade.php ENDPATH**/ ?>