@extends('app')
@section('title', 'Detail parent eleve')
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                @include('includes._alert')
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <h4>Détail parent élève</h4>
                                    <span>
                                        <a href="{{route('parent.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-body">
                                <div class="row py-3">
                                    <div class="col-sm-5 text-center pt-md-5">
                                        <i class="fas fa-user-tie" style="font-size: 80px"></i>
                                        <h4 class="mb-1 mt-2">{{ucfirst($data->first_name).' '.ucfirst($data->last_name)}}</h4>
                                        <p class="text-muted"><strong>{{ucfirst($data->profession)}}</strong></p>
                                        <a href="{{route('parent.edit',$data->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 my-1"> <i class="fas fa-edit"></i> Editer</a>
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="text-start mt-3">
                                            <table class="table table-bordered mt-0">
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nom</span></td>
                                                        <td><strong>{{mb_strtoupper($data->first_name)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Prénoms</span></td>
                                                        <td><strong>{{ucfirst($data->last_name)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Sexe</span></td>
                                                        <td><strong>{{ucfirst($data->sexe == 'H' ? 'Homme':'Femme')}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Profession</span></td>
                                                        <td><strong>{{ucfirst($data->profession)}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Numéro de téléphones</span></td>
                                                        <td><strong>{{$data->telephon1}}{{$data->telephon2 ? '/'.$data->telephon2:null}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Messagerie</span></td>
                                                        <td><strong>{{ucfirst($data->messagerie ? 'Oui':'Non')}}</strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Disponibilité </span></td>
                                                        <td><strong>{{ucfirst($data->status ? 'Oui':'Non')}}</strong></td>
                                                    </tr>
                                                   
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <h5 class="fs-10 text-uppercase">Elèves du parent</h5>
                                        <table class="table table-bordered mt-0">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:15px">N°</th>
                                                    <th>Matricule</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Genre</th>
                                                    <th>Cycle</th>
                                                    <th>Année arrivée</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i = 1; @endphp
                                                @foreach ($data->students as $item)
                                                <tr>
                                                    <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                    <td>{{$item->matricule}}</td>
                                                    <td>{{ucwords($item->first_name)}}</td>
                                                    <td>{{ucwords($item->last_name)}}</td>
                                                    <td>{{$item->sexe == 'F' ? ucfirst('Feminin'):ucfirst('Masculin')}}</td>
                                                    <td>{{ucfirst($item->type)}}</td>
                                                    <td>{{$item->schoolYear->school_year}}</td>
                                                    <td>
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <a href="{{route('student.show',$item->id)}}" class="btn btn-sm btn-primary text-center px-2" title="Detail élève"><i class="fas fa-ellipsis-h"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection