<?php

namespace App\Jobs;

use App\Models\Classe;
use App\Models\Inscription;
use App\Models\MoyenneSubMatter;
use App\Models\CuttingSchoolYear;
use App\Jobs\CalculMoyenneFrenchCycle1;
use App\Jobs\MoyenneAnnuelleSubMatiereJob;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Events\MoyenneSubMatiereEvent;
use Illuminate\Support\Facades\DB;

class CalculMoyenneSubMatter implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $classe, $cutting, $student, $matter, $subMatter;

    public function __construct($student, $classe, $cutting, $matter, $subMatter)
    {
        $this->student = $student;
        $this->classe = $classe;
        $this->cutting = $cutting;
        $this->matter = $matter;
        $this->subMatter = $subMatter;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $cutting = CuttingSchoolYear::find($this->cutting);
        $dts = getClassement($this->calculMoyenneStudent());
        foreach($dts as $item){
            $existe = MoyenneSubMatter::where('inscription_id', $item['id'])->where('sub_matter_id', $this->subMatter)->where('cutting_school_year_id', $this->cutting)->first();
            if($existe){
                $existe->update([
                    'moyenne' => $item['moyen'],
                    'rang' => $item['rang']
                ]);
            }
            else{
                MoyenneSubMatter::create([
                    'inscription_id' => $item['id'],
                    'sub_matter_id' => $this->subMatter,
                    'cutting_school_year_id' => $this->cutting,
                    'moyenne' => $item['moyen'],
                    'rang' => $item['rang'],
                    'coefficient' => $this->getCoefficient()
                ]);
            }
            // Déclenchement de l’événement
            event(new MoyenneSubMatiereEvent($item['id'], $item['moyen'], $item['rang'], $this->getCoefficient(), $cutting->school_year_id, $cutting->cutting->libelle, $this->subMatter, $this->school()));
        }
        CalculMoyenneFrenchCycle1::dispatch($this->student, $this->cutting, $this->matter);

        // Déclenchement de Job pour le calcul des moyennes Annuelles .................
        if($cutting->cutting->end == 'oui'){
            MoyenneAnnuelleSubMatiereJob::dispatch($this->calculMoyenneStudent(), $this->subMatter, $cutting->school_year_id)->delay(now()->addSeconds(1));
        }
    }


    /**
     * Calcul de moyene pour chaque eleves.
     */
    protected function calculMoyenneStudent()
    {
        $datas = $this->getSudentNote();
        $tabs = [];
        foreach($datas as $item){
            $tabs[] = [
                'moyen' => calculMoyenneMatter($item['notes']),
                'id' => $item['student'],
                'sexe' => Inscription::find($item['student'])['student']['sexe']
            ];
        }
        return $tabs;
    }


    /**
     * Association d'un élève à ces notes.
     */
    protected function getSudentNote()
    {
        $tab = [];
        foreach($this->student as $item){
            $tab[] = [
                'student' => $item,
                'notes' => $this->getSubNotesEval($item)
            ];
        }
        return $tab;
    }


    /**
     * Recuperation des notes pour les sous matières
     */
    protected function getSubNotesEval($id_student)
    {
        return json_decode($this->getSubNote($id_student), true);
    }


    protected function getCoefficient()
    {
        $class = Classe::find($this->classe);
        if(in_array($class['level_id'], [12, 13]) && $this->subMatter == 1){
            $coef = 2;
        }
        return $coef ?? 1;
    }


    protected function school(){
        $class = Classe::find($this->classe);
        return $class->school_id;
    }


    // Gestion des sous matieres en français --------------------------------------
    protected function getSubNote($student)
    {
        $datas = DB::TABLE('evaluations')
        ->JOIN('get_notes', 'evaluations.id', '=', 'get_notes.evaluation_id')
        ->JOIN('inscriptions', 'inscriptions.id', '=', 'get_notes.inscription_id')
        ->SELECT('get_notes.note', 'evaluations.notee', 'evaluations.sub_matter_id')
        ->WHERE('get_notes.inscription_id', '=', $student)
        ->WHERE('evaluations.classe_id', '=', $this->classe)
        ->WHERE('evaluations.cutting_school_year_id', '=', $this->cutting)
        ->WHERE('evaluations.level_matter_id', '=', $this->matter)
        ->WHERE('evaluations.sub_matter_id', '=', $this->subMatter)
        ->WHERE('evaluations.status', '=', '1')
        ->orderBy('evaluations.date_create', 'ASC')->get();

        return $datas->where('sub_matter_id', $this->subMatter);
    }
}
