<?php

namespace App\Jobs;

use App\Models\Inscription;
use App\Models\MoyenneMatiere;
use App\Jobs\CalculMoyenneSubMatter;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class CalculMoyenneMatiereJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $classe; 
    protected $decoupage; 
    protected $student;
    protected $matter;
    protected $subMatter;

    /**
     * Create a new job instance.
     */
    public function __construct($student, $classe, $decoupage, $matter, $subMatter = null)
    {
        $this->student = $student;
        $this->classe = $classe;
        $this->decoupage = $decoupage;
        $this->matter = $matter;
        $this->subMatter = $subMatter;
    }


    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if(!$this->subMatter){
            $dts = getClassement($this->calculMoyenneStudent($this->student));
            foreach($dts as $item){
                $existe = MoyenneMatiere::where('inscription_id', $item['id'])->where('level_matter_id', $this->matter)->where('cutting_school_year_id', $this->decoupage)->first();
                if($existe){
                    $existe->update([
                        'moyenne' => $item['moyen'],
                        'rang' => $item['rang']
                    ]);
                }
                else{
                    MoyenneMatiere::create([
                        'inscription_id' => $item['id'],
                        'level_matter_id' => $this->matter,
                        'cutting_school_year_id' => $this->decoupage,
                        'moyenne' => $item['moyen'],
                        'rang' => $item['rang']
                    ]);
                }
            }
        }
        else{
            CalculMoyenneSubMatter::dispatch($this->student, $this->classe, $this->decoupage, $this->matter, $this->subMatter);
        }
    }


    /**
     * Association d'un élève à ces notes.
     */
    protected function getSudentNote($students)
    {
        $table = [];
        foreach($students as $item){
            $table[] = [
                'student' => $item,
                'notes' => $this->getNotesEval($item)
            ];
        }
        return $table;
    }


    /**
     * Calcul de moyene pour chaque eleves.
     */
    protected function calculMoyenneStudent($students)
    {
        $datas = $this->getSudentNote($students);
        $tabs = [];
        foreach($datas as $item){
            $tabs[] = [
                'moyen' => calculMoyenneMatter($item['notes']),
                'id' => $item['student'],
                'sexe' => Inscription::find($item['student'])['student']['sexe']
            ];
        }
        return $tabs;
    }


    /**
     * Recuperation des notes pour chaque eleves.
     */
    protected function getNotesEval($id_student)
    {
        $datas = DB::TABLE('evaluations')
        ->JOIN('get_notes', 'evaluations.id', '=', 'get_notes.evaluation_id')
        ->JOIN('inscriptions', 'inscriptions.id', '=', 'get_notes.inscription_id')
        ->SELECT('get_notes.note', 'evaluations.notee', 'evaluations.sub_matter_id')
        ->WHERE('get_notes.inscription_id', '=', $id_student)
        ->WHERE('evaluations.classe_id', '=', $this->classe)
        ->WHERE('evaluations.cutting_school_year_id', '=', $this->decoupage)
        ->WHERE('evaluations.level_matter_id', '=', $this->matter)
        ->WHERE('evaluations.status', '=', '1')
        ->orderBy('evaluations.date_create', 'ASC')->get();

        return json_decode($datas, true);
    }
}