<?php

use Illuminate\Support\Facades\Route;


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// ----------------------- En production php artisan queue:work --daemon 
// ----------------------- tail -f storage/logs/laravel.logtail -f storage/logs/laravel.log 
// ----------------------- public/.htaccess avec Options +FollowSymLinks laravel

Route::get('/', function () { return redirect()->route('login'); }); // Route login
Route::group(['middleware' => 'auth'], function () {
    Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'dashboard'])->name('dashboard');
    Route::group(['middleware' => 'role'], function () {
        Route::group(['prefix' => 'decoupage'], function () {
            Route::get('/{str}/list', [App\Http\Controllers\DecoupageControlle::class, 'index'])->name('decoupage.index');
            Route::get('/{str}/create', [App\Http\Controllers\DecoupageControlle::class, 'create'])->name('decoupage.create');
            Route::post('/{str}/store', [App\Http\Controllers\DecoupageControlle::class, 'store'])->name('decoupage.store');
            Route::get('/{str}/edit/{id}', [App\Http\Controllers\DecoupageControlle::class, 'edit'])->name('decoupage.edit');
            Route::put('/{str}/edit/{id}', [App\Http\Controllers\DecoupageControlle::class, 'update'])->name('decoupage.update');
            Route::delete('/{str}/destroy/{id}', [App\Http\Controllers\DecoupageControlle::class, 'destroy']);
        });
        Route::group(['prefix' => 'school_year'], function () {
            Route::get('/list', [App\Http\Controllers\SchoolYearController::class, 'index'])->name('school_year.index');
            Route::get('/create', [App\Http\Controllers\SchoolYearController::class, 'create'])->name('school_year.create');
            Route::post('/store', [App\Http\Controllers\SchoolYearController::class, 'store'])->name('school_year.store');
            Route::get('/edit/{id}', [App\Http\Controllers\SchoolYearController::class, 'edit'])->name('school_year.edit');
            Route::put('/edit/{id}', [App\Http\Controllers\SchoolYearController::class, 'update'])->name('school_year.update');
            Route::delete('/destroy/{id}', [App\Http\Controllers\SchoolYearController::class, 'destroy']);
        });
        Route::group(['prefix' => 'school'], function () {
            Route::get('/desabled', [App\Http\Controllers\SchoolController::class, 'index'])->name('school.index');
            Route::get('/create', [App\Http\Controllers\SchoolController::class, 'create'])->name('school.create');
            Route::post('/store', [App\Http\Controllers\SchoolController::class, 'store'])->name('school.store');
            Route::get('/edit/{id}', [App\Http\Controllers\SchoolController::class, 'edit'])->name('school.edit');
            Route::put('/edit/{id}', [App\Http\Controllers\SchoolController::class, 'update'])->name('school.update');
            Route::delete('/destroy/{id}', [App\Http\Controllers\SchoolController::class, 'destroy'])->name('school.destroy');
        });
        Route::group(['prefix' => 'liste_dren'], function () {
            Route::get('/', [App\Http\Controllers\GetDrenController::class, 'index'])->name('liste_dren.index');
            Route::post('/store', [App\Http\Controllers\GetDrenController::class, 'store'])->name('liste_dren.store');
        });
        Route::group(['prefix' => 'nationality'], function () {
            Route::get('/', [App\Http\Controllers\NationalityController::class, 'index'])->name('nationality.index');
            Route::post('/store', [App\Http\Controllers\NationalityController::class, 'store'])->name('nationality.store');
        });
    });
    Route::group(['middleware' => 'getAdmin'], function () {

        Route::group(['prefix' => 'resultat'], function () {
            Route::get('/', [App\Http\Controllers\ResultatController::class, 'index'])->name('resultat.index');
            Route::get('/detail/{id}', [App\Http\Controllers\ResultatController::class, 'show'])->name('resultat.show');
            Route::get('/list/{id}', [App\Http\Controllers\ResultatController::class, 'edit'])->name('resultat.list');
            Route::get('/files', [App\Http\Controllers\ResultatController::class, 'generate'])->name('resultat.pdf');
            Route::get('/matter', [App\Http\Controllers\ResultatController::class, 'matters'])->name('resultat.matter');
        });

        Route::group(['prefix' => 'moyenne'], function () {
            Route::get('/classes', [App\Http\Controllers\GetMoyenneController::class, 'index'])->name('moyenne.index');
            Route::get('/detail/{id}', [App\Http\Controllers\GetMoyenneController::class, 'show'])->name('moyenne.show');
            Route::get('/edit', [App\Http\Controllers\GetMoyenneController::class, 'edit'])->name('moyenne.edit');
            Route::get('/edit/{id}', [App\Http\Controllers\GetMoyenneController::class, 'update'])->name('moyenne.update');
            Route::get('/matter', [App\Http\Controllers\GetMoyenneController::class, 'matters'])->name('moyenne.matter');
            Route::get('/file/{id}', [App\Http\Controllers\GetMoyenneController::class, 'filePdf'])->name('moyenne.file');
            Route::get('/unclassified/{id}', [App\Http\Controllers\GetMoyenneController::class, 'unclassified'])->name('moyenne.unclassified');
            Route::post('/unclassified', [App\Http\Controllers\GetMoyenneController::class, 'submit'])->name('moyenne.submit');
        });

        Route::group(['prefix' => 'evaluation'], function () {
            Route::get('/', [App\Http\Controllers\EvaluationController::class, 'index'])->name('evaluation.index');
            Route::get('/note/{id}', [App\Http\Controllers\EvaluationController::class, 'create'])->name('evaluation.create');
            Route::post('/note/{id}', [App\Http\Controllers\EvaluationController::class, 'storeNote'])->name('evaluation.note');
            Route::get('/detail/{id}', [App\Http\Controllers\EvaluationController::class, 'show'])->name('evaluation.show');
            Route::post('/store', [App\Http\Controllers\EvaluationController::class, 'store'])->name('evaluation.store');
            Route::put('/edit/{id}', [App\Http\Controllers\EvaluationController::class, 'update'])->name('evaluation.update');
            Route::get('/matiere', [App\Http\Controllers\EvaluationController::class, 'getMatiere'])->name('evaluation.matiere');
            Route::get('/matieres', [App\Http\Controllers\EvaluationController::class, 'getEvaluation'])->name('evaluation.matiere_evaluee');
            Route::delete('/destroy/{id}', [App\Http\Controllers\EvaluationController::class, 'destroy'])->name('evaluation.destroy');
            Route::get('/destroy', [App\Http\Controllers\EvaluationController::class, 'getDestroy'])->name('evaluation.delete');
            Route::get('/matieres/{id}', [App\Http\Controllers\EvaluationController::class, 'getReturn'])->name('evaluation.return');
            Route::get('/note_listes/{id}', [App\Http\Controllers\EvaluationController::class, 'noteObtenues'])->name('evaluation.list');
            Route::get('/edit', [App\Http\Controllers\EvaluationController::class, 'edit'])->name('evaluation.edit'); // Edition d'evaluation
            Route::put('/editEval/{id}', [App\Http\Controllers\EvaluationController::class, 'editEval'])->name('evaluation.editEval'); // Edition d'evaluation
            Route::get('/pdf/{id}', [App\Http\Controllers\EvaluationController::class, 'generatePdf'])->name('evaluation.pdf');
            Route::get('/Ajax', [App\Http\Controllers\EvaluationController::class, 'ajaxUpdate'])->name('evaluation.ajaxUpdate');
            Route::get('/export/{id}', [App\Http\Controllers\EvaluationController::class, 'exportFile'])->name('evaluation.export');
            Route::post('/import/{id}', [App\Http\Controllers\EvaluationController::class, 'importFile'])->name('evaluation.import');
            Route::get('/approved/{string}', [App\Http\Controllers\EvaluationController::class, 'approved'])->name('evaluation.approved');
            Route::get('/bonnus_moyenne/{string}', [App\Http\Controllers\EvaluationController::class, 'bonnus'])->name('evaluation.bonnus');
            Route::put('/bonnus_moyenne/{string}', [App\Http\Controllers\EvaluationController::class, 'bonnusUpdate'])->name('evaluation.bonnus_update');
            Route::get('/rattrapage/{id}', [App\Http\Controllers\EvaluationController::class, 'catchingUp'])->name('evaluation.catchingUp');
            Route::get('/devoirs/{str}', [App\Http\Controllers\GetDevoirController::class, 'index'])->name('evaluation.devoir');
            Route::get('/imprim/{str}', [App\Http\Controllers\GetDevoirController::class, 'imprim'])->name('evaluation.imprim');
        });

        Route::group(['prefix' => 'evaluation'], function () {
            Route::get('composition/index', [App\Http\Controllers\CompositionController::class, 'index'])->name('composition.index');
            Route::get('composition/create', [App\Http\Controllers\CompositionController::class, 'create'])->name('composition.create');
            Route::post('composition/create', [App\Http\Controllers\CompositionController::class, 'store'])->name('composition.store');
            Route::get('composition/show', [App\Http\Controllers\CompositionController::class, 'show'])->name('composition.show');
            Route::get('composition/file/{id}', [App\Http\Controllers\CompositionController::class, 'export'])->name('composition.file');
            Route::post('composition/file', [App\Http\Controllers\CompositionController::class, 'import'])->name('composition.import');
            Route::get('composition/index/{id}', [App\Http\Controllers\CompositionController::class, 'return'])->name('composition.return');
            Route::put('composition/destroy/{id}', [App\Http\Controllers\CompositionController::class, 'destroy'])->name('composition.destroy');
        });


        Route::group(['prefix' => 'appel'], function () {
            Route::get('/', [App\Http\Controllers\AppelController::class, 'index'])->name('appel.index');
            Route::get('/create', [App\Http\Controllers\AppelController::class, 'create'])->name('appel.create');
            Route::get('/detail', [App\Http\Controllers\AppelController::class, 'show'])->name('appel.show');
            Route::get('/detail/{id}', [App\Http\Controllers\AppelController::class, 'primary'])->name('appel.primary');
            Route::get('/store/{id}', [App\Http\Controllers\AppelController::class, 'primary_create'])->name('appel.primary_create');
            Route::get('/store', [App\Http\Controllers\AppelController::class, 'store'])->name('appel.store'); // Pointer une heure d'absence
            Route::get('/notstore', [App\Http\Controllers\AppelController::class, 'notStore'])->name('appel.notStore'); // Depointer une heure d'absence
            Route::get('/edit/{id}', [App\Http\Controllers\AppelController::class, 'edit'])->name('appel.edit');
            Route::put('/edit', [App\Http\Controllers\AppelController::class, 'update'])->name('appel.update');
            Route::get('/appel', [App\Http\Controllers\AppelController::class, 'search'])->name('appel.search');
            Route::delete('/destroy/{id}', [App\Http\Controllers\AppelController::class, 'destroy'])->name('appel.destroy');
            Route::get('/return/{string}', [App\Http\Controllers\AppelController::class, 'return'])->name('appel.return');
        });
        Route::group(['prefix' => 'sanction'], function () {
            Route::get('/index', [App\Http\Controllers\SanctionController::class, 'index'])->name('sanction.index');
            Route::get('/create/{id}', [App\Http\Controllers\SanctionController::class, 'create'])->name('sanction.create');
            Route::post('/create', [App\Http\Controllers\SanctionController::class, 'store'])->name('sanction.store');
            Route::get('/detail/{id}', [App\Http\Controllers\SanctionController::class, 'show'])->name('sanction.show');
            Route::get('/edit', [App\Http\Controllers\SanctionController::class, 'edit'])->name('sanction.edit');
            Route::put('/edit/{id}', [App\Http\Controllers\SanctionController::class, 'update'])->name('sanction.update');
            Route::get('/sanction', [App\Http\Controllers\SanctionController::class, 'search'])->name('sanction.search');
            Route::get('/destroy', [App\Http\Controllers\SanctionController::class, 'destroy'])->name('sanction.destroy');
        });
        Route::group(['prefix' => 'sanction'], function () {
            Route::get('/conduite/{id}', [App\Http\Controllers\ConduiteController::class, 'index'])->name('conduite.index');
            Route::post('/conduite/store', [App\Http\Controllers\ConduiteController::class, 'store'])->name('conduite.store');
            Route::put('/edit/{id}', [App\Http\Controllers\ConduiteController::class, 'update'])->name('conduite.update');
            Route::get('/conduite', [App\Http\Controllers\ConduiteController::class, 'search'])->name('conduite.search');
        });
        Route::group(['prefix' => 'inscription'], function () {
            Route::get('/index', [App\Http\Controllers\InscriptionController::class, 'index'])->name('inscription.index');
            Route::get('/create', [App\Http\Controllers\InscriptionController::class, 'create'])->name('inscription.create');
            Route::post('/store', [App\Http\Controllers\InscriptionController::class, 'store'])->name('inscription.store');
            Route::get('/search', [App\Http\Controllers\InscriptionController::class, 'search'])->name('inscription.search');
            Route::get('/level', [App\Http\Controllers\InscriptionController::class, 'getLevel'])->name('inscription.level');
            Route::get('/serie', [App\Http\Controllers\InscriptionController::class, 'getSerie'])->name('inscription.serie');
            Route::get('/classe', [App\Http\Controllers\InscriptionController::class, 'getClasse'])->name('inscription.classe');
            Route::get('/export', [App\Http\Controllers\InscriptionController::class, 'export'])->name('inscription.export');
            Route::post('/import', [App\Http\Controllers\InscriptionController::class, 'import'])->name('inscription.import');
            Route::get('/pdf/{id}', [App\Http\Controllers\InscriptionController::class, 'generatePdf'])->name('inscription.pdf');
            Route::get('/getDelete', [App\Http\Controllers\InscriptionController::class, 'getDelete'])->name('inscription.getDelete');
            Route::delete('/destroy/{id}', [App\Http\Controllers\InscriptionController::class, 'destroy'])->name('inscription.destroy');
        });
        Route::group(['prefix' => 'classe'], function () {
            Route::get('/list', [App\Http\Controllers\ClasseController::class, 'index'])->name('classe.index');
            Route::get('/show/{id}', [App\Http\Controllers\ClasseController::class, 'show'])->name('classe.show');
            Route::get('/create', [App\Http\Controllers\ClasseController::class, 'create'])->name('classe.create');
            Route::get('/serie', [App\Http\Controllers\ClasseController::class, 'series'])->name('classe.serie');
            Route::post('/store', [App\Http\Controllers\ClasseController::class, 'store'])->name('classe.store');
            Route::post('/add', [App\Http\Controllers\ClasseController::class, 'teacher'])->name('classe.teacher');
            Route::get('/edit', [App\Http\Controllers\ClasseController::class, 'edit'])->name('classe.edit');
            Route::get('/pdf/{id}', [App\Http\Controllers\ClasseController::class, 'generatePdf'])->name('classe.pdf');
            Route::put('/edit', [App\Http\Controllers\ClasseController::class, 'update'])->name('classe.update');
            Route::delete('/destroy', [App\Http\Controllers\ClasseController::class, 'destroy'])->name('classe.destroy');

            // Emploi du temploi
            Route::get('/emploi_du_temps/{string}', [App\Http\Controllers\EmploiTempsController::class, 'index'])->name('time.index');
            Route::get('/create/{id}', [App\Http\Controllers\EmploiTempsController::class, 'create'])->name('time.create');
            Route::post('/create/{id}', [App\Http\Controllers\EmploiTempsController::class, 'store'])->name('time.store');
            Route::get('/add_teacher/{id}', [App\Http\Controllers\EmploiTempsController::class, 'add_create'])->name('time.add_create');
            Route::post('/add_teacher', [App\Http\Controllers\EmploiTempsController::class, 'add_store'])->name('time.add_store');
            Route::get('/show_teacher', [App\Http\Controllers\EmploiTempsController::class, 'show'])->name('time.show_teacher');
            Route::get('/time-pdf/{id}', [App\Http\Controllers\EmploiTempsController::class, 'generatePdf'])->name('time.pdf');
            Route::get('/return/{string}', [App\Http\Controllers\EmploiTempsController::class, 'getReturn'])->name('time.classe');
        });
        Route::group(['prefix' => 'user'], function () {
            Route::get('/admin', [App\Http\Controllers\UserController::class, 'index1'])->name('user.index1');
            Route::get('/enseignants', [App\Http\Controllers\UserController::class, 'index'])->name('user.index');
            Route::get('/create/teacher', [App\Http\Controllers\UserController::class, 'create'])->name('user.create');
            Route::get('/create/admin', [App\Http\Controllers\UserController::class, 'create1'])->name('user.create1');
            Route::get('/detail/{id}', [App\Http\Controllers\UserController::class, 'show'])->name('user.show');
            Route::post('/store', [App\Http\Controllers\UserController::class, 'store'])->name('user.store');
            Route::get('/download', [App\Http\Controllers\UserController::class, 'download'])->name('user.download');
            Route::post('/import', [App\Http\Controllers\UserController::class, 'import'])->name('user.import');
            Route::get('/edit/{id}', [App\Http\Controllers\UserController::class, 'edit'])->name('user.edit');
            Route::put('/edit/{id}', [App\Http\Controllers\UserController::class, 'update'])->name('user.update');
            Route::get('/search', [App\Http\Controllers\UserController::class, 'search'])->name('user.search');
            Route::get('/ajax', [App\Http\Controllers\UserController::class, 'getlevel'])->name('user.ajax');
            Route::get('/searchAjax', [App\Http\Controllers\UserController::class, 'searchAjax'])->name('user.searchAjax');
            Route::delete('/destroy/{id}', [App\Http\Controllers\UserController::class, 'destroy'])->name('user.destroy');
            Route::post('/change-pwd', [App\Http\Controllers\PasswordController::class, 'passwordChange'])->name('pwd.update');
            Route::get('/inactif', [App\Http\Controllers\UserController::class, 'inactif'])->name('user.inactif');
        });
        Route::group(['prefix' => 'student'], function () {
            Route::get('/index', [App\Http\Controllers\StudentController::class, 'index'])->name('student.index');
            Route::get('/inactif', [App\Http\Controllers\StudentController::class, 'index1'])->name('student.index1');
            Route::get('/create/{id}', [App\Http\Controllers\StudentController::class, 'create'])->name('student.create');
            Route::post('/store', [App\Http\Controllers\StudentController::class, 'store'])->name('student.store');
            Route::get('/detail/{id}', [App\Http\Controllers\StudentController::class, 'show'])->name('student.show');
            Route::get('/edit/{id}', [App\Http\Controllers\StudentController::class, 'edit'])->name('student.edit');
            Route::put('/edit/{id}', [App\Http\Controllers\StudentController::class, 'update'])->name('student.update');
            Route::get('/search', [App\Http\Controllers\StudentController::class, 'search'])->name('student.search');
            Route::get('/download', [App\Http\Controllers\StudentController::class, 'download'])->name('student.download');
            Route::post('/file', [App\Http\Controllers\StudentController::class, 'fileStore'])->name('student.file');
            Route::get('/delete', [App\Http\Controllers\StudentController::class, 'delete'])->name('student.delete');
            Route::delete('/destroy/{id}', [App\Http\Controllers\StudentController::class, 'destroy'])->name('student.destroy');

            Route::group(['prefix' => 'parent'], function () {
                Route::get('/index', [App\Http\Controllers\ParentController::class, 'index'])->name('parent.index');
                Route::get('/create', [App\Http\Controllers\ParentController::class, 'create'])->name('parent.create');
                Route::post('/store', [App\Http\Controllers\ParentController::class, 'store'])->name('parent.store');
                Route::get('/detail/{id}', [App\Http\Controllers\ParentController::class, 'show'])->name('parent.show');
                Route::get('/edit/{id}', [App\Http\Controllers\ParentController::class, 'edit'])->name('parent.edit');
                Route::put('/edit/{id}', [App\Http\Controllers\ParentController::class, 'update'])->name('parent.update');
                Route::get('/search', [App\Http\Controllers\ParentController::class, 'search'])->name('parent.search');
                Route::get('/search2', [App\Http\Controllers\ParentController::class, 'search2'])->name('parent.search2');
                Route::delete('destroy/{id}', [App\Http\Controllers\ParentController::class, 'destroy'])->name('parent.destroy');
            });
        });
        Route::group(['prefix' => 'payment'], function () {
            Route::get('/list', [App\Http\Controllers\PaymentController::class, 'index'])->name('payment.index');
            Route::get('/create', [App\Http\Controllers\PaymentController::class, 'create'])->name('payment.search');
            Route::get('/verify', [App\Http\Controllers\PaymentController::class, 'verify'])->name('payment.verify');
            Route::get('/detail/{id}', [App\Http\Controllers\PaymentController::class, 'show'])->name('payment.show');
            Route::get('/detail', [App\Http\Controllers\PaymentController::class, 'detail'])->name('payment.detail');
            Route::post('/store', [App\Http\Controllers\PaymentController::class, 'store'])->name('payment.store');
            Route::post('/import', [App\Http\Controllers\PaymentController::class, 'import'])->name('payment.import');
             Route::get('/search', [App\Http\Controllers\PaymentController::class, 'search'])->name('canteen.search');
        });
        Route::group(['prefix'  => 'config'], function() {
            Route::group(['prefix' => 'matter'], function () {
                Route::get('/index', [App\Http\Controllers\MatterController::class, 'index'])->name('matiere.index');
                Route::get('/create/{str}', [App\Http\Controllers\MatterController::class, 'create'])->name('matiere.create');
                Route::post('/store', [App\Http\Controllers\MatterController::class, 'store'])->name('matiere.store');
                Route::get('/update', [App\Http\Controllers\MatterController::class, 'update'])->name('matiere.update');
                Route::get('/search', [App\Http\Controllers\MatterController::class, 'search'])->name('matiere.search');
                Route::put('/matter/{id}', [App\Http\Controllers\MatterController::class, 'matter'])->name('matiere.matter');

                Route::post('/getMatter/{str}', [App\Http\Controllers\GetMatterController::class, 'create'])->name('getmatter.create');
                Route::post('/getMatter', [App\Http\Controllers\GetMatterController::class, 'store'])->name('getMatter.store');
                Route::put('/getMatter/{id}', [App\Http\Controllers\GetMatterController::class, 'update'])->name('getMatter.update');   
                Route::get('/getMatter', [App\Http\Controllers\GetMatterController::class, 'search'])->name('getMatter.search');
                Route::get('/serie', [App\Http\Controllers\GetMatterController::class, 'searchSerie'])->name('getMatter.serie');
                Route::put('/getMatter/{id}', [App\Http\Controllers\GetMatterController::class, 'matter'])->name('getMatter.matter');
            });
            Route::group(['prefix' => 'setting'], function () {
                Route::get('/index', [App\Http\Controllers\SettingController::class, 'index'])->name('setting.index');
                Route::get('/create', [App\Http\Controllers\SettingController::class, 'create'])->name('setting.create');
                Route::post('/store', [App\Http\Controllers\SettingController::class, 'store'])->name('setting.store');
                Route::get('/edit/{id}', [App\Http\Controllers\SettingController::class, 'edit'])->name('setting.edit');
                Route::put('/edit/{id}', [App\Http\Controllers\SettingController::class, 'update'])->name('setting.update');
                Route::delete('/destroy/{id}', [App\Http\Controllers\SettingController::class, 'destroy'])->name('setting.destroy');
            });
            Route::group(['prefix' => 'level'], function () {
                Route::get('/index', [App\Http\Controllers\LevelController::class, 'index'])->name('level.index');
                Route::post('/serie', [App\Http\Controllers\LevelController::class, 'storeSerie'])->name('level.serie');
                Route::post('/store', [App\Http\Controllers\LevelController::class, 'storeFiliere'])->name('level.filiere');
                Route::get('/search', [App\Http\Controllers\LevelController::class, 'searchLevel'])->name('level.search');
                Route::get('/serie', [App\Http\Controllers\LevelController::class, 'searchSerie'])->name('level.series');
                Route::get('/mattiere', [App\Http\Controllers\LevelController::class, 'mattiere'])->name('level.mattiere');
                Route::put('/edit/{id}', [App\Http\Controllers\LevelController::class, 'update'])->name('level.update');
                Route::get('/list', [App\Http\Controllers\LevelController::class, 'list'])->name('level.list');
                Route::put('/destroy/{id}', [App\Http\Controllers\LevelController::class, 'destroy'])->name('level.destroy');
            });
            Route::group(['prefix' => 'time_slot'], function () {
                Route::get('/list', [App\Http\Controllers\SlotTimeController::class, 'index'])->name('time_slot.index');
                Route::get('/create', [App\Http\Controllers\SlotTimeController::class, 'create'])->name('time_slot.create');
                Route::post('/store', [App\Http\Controllers\SlotTimeController::class, 'store'])->name('time_slot.store');
                Route::post('/update', [App\Http\Controllers\SlotTimeController::class, 'update'])->name('time_slot.update');
            });
            Route::group(['prefix' => 'report'], function () {
                Route::get('/index', [App\Http\Controllers\SchoolReportController::class, 'index'])->name('report1.index');
                Route::get('/create', [App\Http\Controllers\SchoolReportController::class, 'create'])->name('report1.create');
                Route::post('/store', [App\Http\Controllers\SchoolReportController::class, 'store'])->name('report1.store');
                Route::get('/pdf', [App\Http\Controllers\SchoolReportController::class, 'getPdf'])->name('report1.pdf');
            });
        });
        Route::group(['prefix'  => 'estimation'], function() {
            Route::group(['prefix' => 'frais'], function () {
                Route::get('/index', [App\Http\Controllers\AnnexFeeController::class, 'index'])->name('frais.index');
                Route::get('/create', [App\Http\Controllers\AnnexFeeController::class, 'create'])->name('frais.create');
                Route::post('/store', [App\Http\Controllers\AnnexFeeController::class, 'store'])->name('frais.store');
                Route::get('/edit', [App\Http\Controllers\AnnexFeeController::class, 'edit'])->name('frais.edit');
                Route::put('/destroy/{id}', [App\Http\Controllers\AnnexFeeController::class, 'destroy'])->name('frais.destroy');
            });
            Route::group(['prefix' => 'scolarite'], function () {
                Route::get('/index', [App\Http\Controllers\ScolarityController::class, 'index'])->name('scolarite.index');
                Route::get('/create', [App\Http\Controllers\ScolarityController::class, 'create'])->name('scolarite.create');
                Route::post('/store', [App\Http\Controllers\ScolarityController::class, 'store'])->name('scolarite.store');
                Route::get('/edit', [App\Http\Controllers\ScolarityController::class, 'edit'])->name('scolarite.edit');
                Route::put('/destroy/{id}', [App\Http\Controllers\ScolarityController::class, 'destroy'])->name('scolarite.destroy');
            });
            Route::group(['prefix' => 'transport'], function () {
                Route::get('/index', [App\Http\Controllers\TransportController::class, 'index'])->name('transport.index');
                Route::get('/create', [App\Http\Controllers\TransportController::class, 'create'])->name('transport.create');
                Route::post('/add_zone', [App\Http\Controllers\TransportController::class, 'addZone'])->name('transport.add_zone');
                Route::post('/store', [App\Http\Controllers\TransportController::class, 'store'])->name('transport.store');
                Route::post('/edit', [App\Http\Controllers\TransportController::class, 'edit'])->name('transport.edit');
                Route::post('/destroy', [App\Http\Controllers\TransportController::class, 'destroy'])->name('transport.destroy');
                Route::post('/delete', [App\Http\Controllers\TransportController::class, 'delete'])->name('transport.delete');
            });
            Route::group(['prefix' => 'cantine'], function () {
                Route::get('/index', [App\Http\Controllers\CanteenController::class, 'index'])->name('canteen.index');
                Route::post('/store', [App\Http\Controllers\CanteenController::class, 'store'])->name('canteen.store');
                Route::post('/destroy', [App\Http\Controllers\CanteenController::class, 'destroy'])->name('canteen.destroy');
            });
        });

        Route::group(['prefix' => 'program'], function () {
            Route::get('/index', [App\Http\Controllers\ProgramDevoirController::class, 'index'])->name('program.index');
            Route::get('/class', [App\Http\Controllers\ProgramDevoirController::class, 'getClass'])->name('program.class');
            Route::get('/create', [App\Http\Controllers\ProgramDevoirController::class, 'create'])->name('program.create');
            Route::post('/store', [App\Http\Controllers\ProgramDevoirController::class, 'store'])->name('program.store');
            Route::get('/edit', [App\Http\Controllers\ProgramDevoirController::class, 'edit'])->name('program.edit');
            Route::post('/update', [App\Http\Controllers\ProgramDevoirController::class, 'update'])->name('program.update');
            Route::post('/delete', [App\Http\Controllers\ProgramDevoirController::class, 'destroy'])->name('program.delete');
        });

        Route::group(['prefix' => 'globals'], function () {
            Route::get('/index', [App\Http\Controllers\GlobalRapportController::class, 'index'])->name('globals.index');
        });
    });
});