<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Program Devoir - {{ $classe['libelle'] }}</title>
</head>
<style type="text/css">
    @page {
        margin: 1.5cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 14px
    }
    .watermark {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%) rotate(-50deg);
        font-size: 100px;
        color: rgba(0, 0, 0, 0.05);
        z-index: -1;
        white-space: nowrap;
        text-decoration: underline;
        pointer-events: none;
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <div class="watermark">Classe : {{ $classe->libelle }}</div>
    <header style="margin-top: 10%; margin-bottom: 10%; ">
        <table style="width: 100%">
            <tbody>
                <tr>
                    <td>
                        <div class="bloc1" style="width: 70%; text-align: center;">
                            <p style="font-size: 14px; margin-bottom: 0%"><strong>MINISTERE DE L’EDUCATION NATIONALE <br> ET DE L’ALPHABETISATION</strong></p>
                            <p style="margin-top:0%">....................................</p>
                            <p style="font-size: 12px; margin-bottom: 5px">{{$school->school->name_school}}</p>
                            <img src="{{public_path($school->logoUrl())}}" class="m-b-10 w-100 my-0" alt="Logo School" style="height: 55px;"><br>
                        </div>
                    </td>

                    <td>
                        <div class="bloc2" style="width: 100%; text-align: center;">
                            <p style="font-weight: bold;">REPUBLIQUE DE COTE D'IVOIRE</p>
                            <p>Union - Discipline - Travail</p>
                            <img src="{{ public_path('assets/images/armoiries.png') }}" class="m-b-10 w-100" alt="Armoirie Ivoirienne" style="height: 55px;">
                            <p style="font-size: 15px; text-decoration: underline; margin-top: 20px">
                                <b style="font-size: 17px">{{$cutting->schoolYear->school_year}}</b>
                            </p>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </header>
    <section style="margin-top: 12%;">
        <div style="margin: 1px auto; width: 100%; text-align:center;  margin-bottom: 15%">
            <strong style="font-size: 25px; height: 100px; line-height: 1.3; text-decoration: underline;">PROGRAMME DE DEVOIRS {{ strtoUpper($cutting->cutting->libelle) }}</strong>
        </div>

        <p style="margin-top: 30px">
            <table border="1" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th scope="col" class="text-center" style="width: 16%; padding: 17px">MATIERES</th>
                        <th scope="col" class="text-center" style="width: 42%; padding: 17px">MATIN</th>
                        <th scope="col" class="text-center" style="width: 42%; padding: 17px">APRES MIDI</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($matters as $matter)
                    <tr>
                        <th scope="col" style="margin:0%; padding:0%; text-align: left">
                            <span style="margin-left: 5px">{{ $matter['libelle'] }}</span>
                        </th>
                        <td style="margin:{{ count($matter['martins']) ? '0%':'' }}; padding:{{ count($matter['martins']) ? '0%':'20px' }}">
                            @if (count($matter['martins']))
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 13px; margin:0%">
                                <tbody style="margin:0%; padding:0%">
                                    <tr style="margin:0%;">
                                        @foreach ($matter['martins'] as $item)
                                            <td style="margin: 0%; text-align:center;">
                                                {{ ucwords($item['jour']) }}<br> 
                                                <strong>{{ date('d/m/Y', strtotime($item['date'])) }}</strong><br>
                                                {{ $item['debut'] }} - {{ $item['fins'] }}
                                            </td>
                                        @endforeach
                                    </tr>
                                </tbody>
                            </table>
                            @endif
                        </td>
                        <td style="margin:{{ count($matter['soirs']) ? '0%':'' }}; padding:{{ count($matter['soirs']) ? '0%':'20px' }}">
                            @if (count($matter['soirs']))
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 13px; margin:0%">
                                <tbody style="margin:0%; padding:0%">
                                    <tr style="margin:0%;">
                                        @foreach ($matter['soirs'] as $item)
                                            <td style="margin: 0%; text-align:center;">
                                                {{ ucwords($item['jour']) }} <br> 
                                                <strong>{{ date('d/m/Y', strtotime($item['date'])) }}</strong><br>
                                                {{ $item['debut'] }} - {{ $item['fins'] }}
                                            </td>
                                        @endforeach
                                    </tr>
                                </tbody>
                            </table>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </p>
    </section>
    <footer class="footer">
        <div style="display: flex; flex-wrap: wrap; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr>
                        <td style="width: 40%; text-align: left">
                            <span>{{mb_strtoupper($school->school->name_school)}}</span>
                        </td>
                        <td style="width: 30%; text-align: center">
                            <span>©{{$cutting->schoolYear->school_year}}</span>
                        </td>
                        <td style="width: 30%; text-align: right">
                            <span>{{$school->address_email}} / {{$school->phon_school}}</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </footer>
</body>
</html>