@extends('app')
@section('title', 'List DREN')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        @include('includes._alert')
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Lisste des nationalités</h4>
                                    <span>
                                        @if (!sizeof($pays))
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1" data-toggle="modal" data-target="#addDrenModal"><i class="fas fa-plus mx-0"></i></button>
                                        @endif
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="autofill" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center">N°</th>
                                                <th>Pays</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1; @endphp
                                            @foreach ($pays as $item)
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td>{{ucfirst($item->libelle)}}</td>
                                                <td class="text-center">
                                                    <span class="pcoded-badge label label-{{$item['status'] ? 'success':'danger'}}">{{$item['status'] ? 'Actif':'Inactif'}}</span>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="addDrenModal" tabindex="-1" role="dialog" aria-labelledby="addDrenModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addDrenModalTitle">File Import</h5>
        </div>
        <form action="{{route('nationality.store')}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="modal-body px-3 py-4">
                <div class="form-group mt-2">
                    <label class="col-form-label" for="files">Fichier Excel des nationalités<span class="text-danger">*</span> :</label><br>
                    <input type="file" name="files" id="files" class="form-control" placeholder="Charger le fichier de format Excel">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
  </div>
<!-- Modal -->
@include('includes._modal_simple')
@endsection
@section('script')
<script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
<script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

<script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $('docemnt').ready(function(){
        
    });
</script>
@endsection