@extends('app')
@section('title', 'Dashboard')
@section('link')
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/component.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        {{-- SuperAdmin --}}
                        @if (auth()->user()->role->role === 'superAdmin') 
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Etablissements Disponibles - {{count($schools) <= 9 ? '0'.count($schools):count($schools)}}</h4>
                                    <span>
                                        <a href="{{route('school.create')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Add School"><i class="fas fa-plus mx-0"></i></a>
                                        <a href="{{route('school.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Disabled School"> <i class="fas fa-underline m-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block tab-content">
                                <div class="table-responsive dt-responsive">
                                    <table id="autofill" class="table table-striped table-bordered nowrap" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%">N°</th>
                                                <th style="width: 35%">Etablissement</th>
                                                <th style="width: 20%">Numéro Autorisation</th>
                                                <th style="width: 20%">Code Etablissement</th>
                                                <th class="text-center" style="width: 20%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1 @endphp
                                            @foreach ($schools as $school)
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td>{{ucfirst($school->name_school)}}</td>
                                                <td>{{ucfirst($school->num_autorisation)}}</td>
                                                <td>{{ucfirst($school->code_school)}}</td>
                                                <td class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <a href="{{route('school.edit',$school->id)}}" class="btn btn-sm btn-info text-center px-2"><i class="far fa-edit"></i></a>
                                                        {{-- <button class="getIdButton btn btn-sm btn-danger text-white text-center px-2" data-div="{{$school->id}}" data-toggle="modal" data-target="#exampleModalCenter"><i class="far fa-trash-alt"></i></button> --}}
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        {{-- End SuperAdmin --}}                            
                        @else
                            <div class="page-body">
                                <div class="row">
                                    <!--  -->
                                    @forelse ($effetifs as $val)
                                        <div class="col-md-6 col-xl-3">
                                            <div class="card widget-card-1">
                                                <div class="card-block-small">
                                                    <i class="fas fa-chart-pie bg-c-blue card1-icon"></i>
                                                    <span class="text-c-blue f-w-600">Effectif</span>
                                                    <h5>{{preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', ($val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']))}}</h5>
                                                    <div>
                                                        <span class="f-left m-t-10 text-muted">
                                                            <i class="text-c-blue f-16 fa fa-home m-r-10"></i> {{ ucwords($val['libelle']) }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                        <div class="col-12 text-center">
                                            <div class="card" style="width: 50%; margin: 1px auto">
                                                <div class="card-body">
                                                    <h4>Faites les parametrages pour commencer</h4>
                                                </div>
                                            </div>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
@include('includes._modal_simple')
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>    

    <script src="{{asset('assets/js/modalEffects.js')}}"></script>
    <script src="{{asset('assets/js/classie.js')}}"></script>

    <script src="{{asset('bower_components/chart.js/dist/Chart.js')}}"></script>
    <script src="{{asset('assets/pages/widget/amchart/amcharts.js')}}"></script>
    <script src="{{asset('assets/pages/widget/amchart/serial.js')}}"></script>
    <script src="{{asset('assets/pages/widget/amchart/light.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/SmoothScroll.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/pages/dashboard/analytic-dashboard.min.js')}}"></script>
@endsection