<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class School extends Model
{
    protected $guarded = [];

    public function setting(){
        return $this->hasMany(Setting::class);
    }

    public function typeEnseignements(){
        return $this->belongsToMany(TypeEnseignement::class, 'school_type_enseignement', 'school_id', 'type_enseignement_id');
    }


    public function series(){
        return $this->belongsToMany(Serie::class, 'school_serie', 'school_id', 'serie_id');
    }


    public function levels(){
        return $this->belongsToMany(Level::class, 'filiere_school', 'school_id', 'level_id');
    }
    
}
