<?php

// School id
if(!function_exists('getPrefix')){
    function getuserSchoolId(){
        return auth()->user()->school->id;
    }
}


// Fonction permettant de limitter le caractère
if(!function_exists('limitCaracts')){
    function limitCaracts($caractere,$nbre){
        return ucfirst(Str::limit($caractere, $nbre, ''));
    }
}


// Génération de mot de passe par default de l'utilisateur
if(!function_exists('generatePwd')){
    function generatePwd($long = 6){ 

        $Chaine = "abcdefghijklmnopqrstuvwxyz0123456789";
        $Chaine = str_shuffle($Chaine);

        return substr($Chaine,0,$long);
    }
}


// Formatage du nom et prenom de l'utilisateur connecté
if(!function_exists('userName')){
    function userName(){
        return ucfirst(auth()->user()->first_name).' '.ucfirst(Str::limit(auth()->user()->last_name, 5, '...'));
    }
}


// Virifaction de l'existance d'un élément dans un tableau associatif
if(!function_exists('getVerify')){
    function getVerify($tab, $id, $valeur){
        if($tab){
            foreach($tab as $item){
                if($item[$valeur] == $id){
                    return true;
                }
            }
        }
        else{
            return false;
        }
    }
}


// Formatage et affichage du type d'enseignement
if(!function_exists('getAffiche')){
    function getAffiche($tableau){
        $i = 1;
        $str = '';
        foreach($tableau as $item){
            if($i == count($tableau)){
                $str .= ucfirst($item['type_enseignement']);
            }
            else{
                $str .= ucfirst($item['type_enseignement']).' / ';
            }
            $i++;
        }
        return $str;
    }
}

// Vérification de l'existance de prescolaire & primaire au sein de l'etablissement
if(!function_exists('verifyPrimaire')){
    function verifyPrimaire($data){
        $exist = [];
        foreach($data as $item){
            if($item['id'] == 1){
                $exist[] = $item['id'];
            }
            elseif($item['id'] == 2){
                $exist[] = $item['id']; 
            }
        }

        if(count($exist) == 1){
            $string  = $exist[0] == 1 ? 'Prescolaire':'Primaire';
        }
        else{
            $string = 'Prescolaire - Primaire';
        }
        return $string;
    }
}

// Vérification de l'existance de cycle 1 & 2
if(!function_exists('verifySeconde')){
    function verifySeconde($data){
        $exist = [];
        foreach($data as $item){
            if($item['id'] == 3){
                $exist[] = $item['id'];
            }
            elseif($item['id'] == 4){
                $exist[] = $item['id']; 
            }
        }

        if(count($exist) == 1){
            $string  = $exist[0] == 3 ? 'Collège':'Lycée';
        }
        else{
            $string = 'Collège - Lycée';
        }
        return $string;
    }
}

// Changer la vauleur de prescolaire et primaire en "primaire" ou cycle 1 & 2 en "secondaire"
if(!function_exists('changeVal')){
    function changeVal($val){
        if(in_array($val, ['Collège - Lycée','Lycée','Collège'])){
            $val = 'secondaire';
        }
        elseif(in_array($val, ['Prescolaire - Primaire','Prescolaire','Primaire'])){
            $val = 'primaire';
        }
        return $val;
    }
}


// Trouve l'id du niveau 
if(!function_exists('getIdLevel')){
    function getIdLevel($val){
        switch ($val) {
            case 'Collège - Lycée':
                return $tab[] = [3,4];
                break;
            case 'Collège':
                return $tab[] = [3];
                break;
            case 'Lycée':
                return $tab[] = [4];
                break;
            case 'Prescolaire - Primaire':
                return $tab[] = [1,2];
                break;
            case 'Prescolaire':
                return $tab[] = [1];
                break;
            case 'Primaire':
                return $tab[] = [2];
                break;
            case 'supérieur':
                return $tab[] = [6];
                break;
            default:
                return $tab[] = [4]; // L'enseignement Technique utilise le même niveaux que celui du cycle 2
        }
    }
}


if(!function_exists('verifyGetId')){
    function verifyGetId($tab, $val, $val2){
        $exist = [];
        foreach($tab as $item){
            if($item['id'] == $val){
                $exist[] = $item['id'];
            }
            elseif($item['id'] == $val2){
                $exist[] = $item['id']; 
            }
        }
        return count($exist);
    }
}


if(!function_exists('getLevelSerie')){
    function getLevelSerie($datas, $level, $str){
        $tab = [];
        foreach($datas as $item){
            if($item[$level] && $item['type'] == $str){
                $tab[] = $item;
            }
        }
        return $tab;
    }
}


if(!function_exists('formatAffichage')){
    function formatAffichage($tab){
        $val = '';
        $i = 1;
        foreach($tab as $item){
            $val .= $i == 1 ? mb_strtoupper($item->serie):' - '.mb_strtoupper($item->serie);
            $i++;
        }
        return $val;
    }
}


if(!function_exists('verifyDateDecoupage')){
    function verifyDateDecoupage($dateDebut, $dateFin, $dateJour){
        $status = ['0', '1', '2'];
        $dateDebut = strtotime($dateDebut);
        $dateFin = strtotime($dateFin);
        $dateJour = strtotime($dateJour);
        
        if((($dateDebut) > $dateJour) && ($dateFin > $dateJour)){
            $val = $status[0];
        }
        elseif(($dateDebut <= $dateJour) && ($dateFin >= $dateJour)){
            $val = $status[1];
        }
        elseif(($dateDebut < $dateJour) && ($dateFin < $dateJour)){
            $val = $status[2];
        }

        return $val;
    }
}

// Calcul de moyenne par matiere
if(!function_exists('calculMoyenneMatter')){
    function calculMoyenneMatter($data){
        $eval = 0; $totals = 0; $exist = false;
        foreach($data as $item){
            if(!($item['note'] == 'nc')){
                $totals += $item['note']; $eval += $item['notee']; $exist = true;
            }
        }
        $moy = $exist ? ($totals ? number_format(($totals / $eval), 2, '.', ' '):'0'):'nc';
        return $exist ? ($moy < 10 ? '0'.$moy:$moy):$moy;
    }
}


// Calcul La Moyenne En Français Du Cycle 1
if(!function_exists('moyenneFrenchcycle1')){
    function moyenneFrenchcycle1($data){
        $total = 0; $coef = 0; $exist = false;
        foreach($data as $item){
            if(!($item == 'nc')){
                if($item[0] != 'nc'){
                   $total += ((float)$item[0])*$item[1]; $coef += $item[1]; $exist = true; 
                }
            }
        }
        $moy = $exist ? ($total ? number_format(($total / $coef), 2, '.', ' '):'0'):'nc';
        return $exist ? ($moy < 10 ? '0'.$moy:$moy):$moy;
    }
}



// Faire le classement des élèves
if(!function_exists('getClassement')){
    function getClassement($data){
        // Trier le tableau par ordre décroissant des moyennes
        array_multisort(array_column($data, 'moyen'), SORT_DESC, $data);
        $previous_score = null;
        $rank = 1;
        $adjusted_rank = 1;
        $tab = [];
        foreach ($data as $item) {
            if ($previous_score === $item['moyen']){
                $item['rang'] = $adjusted_rank.'ex';
                $tab[] = $item;
            } 
            else {
                $item['rang'] = $item['moyen'] == 'nc' ? '--':($rank > 1 ? $rank.'ème':($item['sexe'] == 'F' ? $rank.'ère':$rank.'er'));
                $tab[] = $item;
                $adjusted_rank = $item['moyen'] == 'nc' ? '--':$rank; // Mémoriser le rang pour les ex-aequo
            }
            $previous_score = $item['moyen'] == 'nc' ? $previous_score:$item['moyen']; // Mettre à jour le score précédent
            $item['moyen'] == 'nc' ? $rank:$rank++; // Incrementer le rang pour la prochaine personne
        }
        return $tab;
    }
}



// Determination du sexe de parent prise en charge des etudes
if(!(function_exists('determinedSex'))){
    function determinedSex($val){
        switch ($val) {
            case 'Mere':
                return 'F';
                break;
            case 'Tutrice':
                return 'F';
                break;
            default:
                return 'H';
        }
    }
}



if(!(function_exists('detnedValeur'))){
    function detnedValeur($val){
        switch ($val) {
            case 'Mere':
                return 'mere';
                break;
            case 'Pere':
                return 'pere';
                break;
            default:
                return 'tuteur';
        }
    }
}



if(!(function_exists('typeEnseignementId'))){
    function typeEnseignementId($val){
        switch ($val) {
            case 'secondaire':
                return $tab[] = [3,4];
                break;
            case 'primaire':
                return $tab[] = [1,2];
                break;
            default:
                return $tab[] = [4]; // L'enseignement Technique utilise le même niveaux que celui du cycle 2
        }
    }
}

// Fonction permettant d'afficher une matiere
if(!(function_exists('afficheMatterEmploiTemps'))){
    function afficheMatterEmploiTemps($matier, $matId, $row, $jour, $heur, $col = null){
        $colone = $col ? 'morning_time_id':'after_noon_time_id';
        foreach($matier as $item){
            if(($item->ligne == ($row +1)) && ($item->week_day_id == $jour) && ($item->matter_id == $matId) && ($item->$colone == $heur)){
                $id = $item->matter_id;
            }
        }
        return $id ?? 0;
    }
}


if(!(function_exists('verifyMatterLv2'))){
    function verifyMatterLv2($valeur){
        switch ($valeur) {
            case 9: // id = 9 correspond Allemand
                return true;
                break;
            case 8: // id = 8 correspond Espagnol
                return true;
                break;
            default:
                return false;
        }
    }
}


// F
if(!(function_exists('verifyteacherClass'))){
    function verifyteacherClass($exist, $matId, $user, $val = null){
        foreach($exist as $item){
            if($val && ($item->user_id == $user) && ($item->matter_id == $matId) && $item->prof_prl){
                $id = $item->user_id;
            }
            elseif( ($item->user_id == $user) && ($item->matter_id == $matId)){
                $id = $item->user_id;
            }
        }
        return $id ?? 0;
    }
}


if(!(function_exists('calculTotatPoint'))){
    function calculTotatPoint($data){
        $valeur = 0;
        foreach($data as $item){
            $valeur += $item['valeur'];
        }
        return $valeur;
    }
}



if(!(function_exists('calculMoyennePrimary'))){
    function calculMoyennePrimary($data){
        $valeur = 0; $point = 0;
        foreach($data as $item){
            $valeur += $item['valeur'];
            $point += $item['note'] ? (int)$item['note']['note']:null;
        }
        $moy = $point ? number_format(($point / intval($valeur / 10)), 2, '.', ' '):'nc';
        $tab = [
            'moyen' => $point ? ($moy < 10 ? '0'.$moy:$moy):$moy,
            'point' => $point ?? 'nc'
        ];
        return $tab;
    }
}



// Retourne l'appréciation selon la moyenne ..................
if(!function_exists('appreciation')){
    function appreciation($moyenne){
        switch (true) {
            case ($moyenne >= 18 && $moyenne <= 20):
                $val = 'Félicitation';
                break;
            case ($moyenne >= 16 && $moyenne < 18):
                $val = 'Très bien';
                break;
            case ($moyenne >= 14 && $moyenne < 16):
                $val = 'Bien';
                break;
            case ($moyenne >= 12 && $moyenne < 14):
                $val = 'Assez bien';
                break;
            case ($moyenne >= 10 && $moyenne < 12):
                $val = 'Passable';
                break;
            case ($moyenne >= 8 && $moyenne < 10):
                $val = "Avertissement";
                break;
            case ($moyenne > 8):
                $val = "Blâme";
                break;
            default:
                $val = "---";
                break;
        }
        return $val;
    }
}



if(!(function_exists('calculMoyenneCoefficenter'))){
    function calculMoyenneCoefficenter($moyenne, $coeff){
        return $moyenne != 'nc' ? number_format(((int)$moyenne * (int)$coeff), 2, '.', ' '):'nc';
    }
}



if(!(function_exists('distinction'))){
    function distinction($moy, $min, $max){
        // return ($moy >= $min && $moy < $max) ? true:false;
        switch (true) {
            case ($moy >= $min && $moy < $max):
                $val = true;
                break;
            default:
                $val = false;
                break;
        }
        return $val;
    }
}


// Appréciation Pour Enseignement Général
if(!(function_exists('appreciationGeneral'))){
    function appreciationGeneral($moyenne){
        switch (true) {
            case ($moyenne >= 17 && $moyenne <= 20):
                $val = 'Excellent';
                break;
            case ($moyenne >= 16 && $moyenne < 17):
                $val = 'Très bien';
                break;
            case ($moyenne >= 14 && $moyenne < 16):
                $val = 'Bien';
                break;
            case ($moyenne >= 12 && $moyenne < 14):
                $val = 'Assez bien';
                break;
            case ($moyenne >= 10 && $moyenne < 12):
                $val = 'Passable';
                break;
            case ($moyenne >= 8 && $moyenne < 10):
                $val = "Insuffisant";
                break;
            case ($moyenne >= 6 && $moyenne < 8):
                $val = "Faible";
                break;
            default:
                $val = "Médiocre";
                break;
        }
        return $val;
    }
}


// Appréciation Pour Enseignement Technique
if(!(function_exists('appreciationTechnique'))){
    function appreciationTechnique($moyenne){
        switch (true) {
            case ($moyenne >= 18 && $moyenne <= 20):
                $val = 'Excellent';
                break;
            case ($moyenne >= 17 && $moyenne < 18):
                $val = 'Très bien';
                break;
            case ($moyenne >= 16 && $moyenne < 17):
                $val = 'Bien';
                break;
            case ($moyenne >= 14 && $moyenne < 16):
                $val = 'Assez bien';
                break;
            case ($moyenne >= 12 && $moyenne < 14):
                $val = 'Passable';
                break;
            case ($moyenne >= 10 && $moyenne < 12):
                $val = "Insuffisant";
                break;
            case ($moyenne >= 8 && $moyenne < 10):
                $val = "Faible";
                break;
            case ($moyenne >= 6 && $moyenne < 8):
                $val = "Médiocre";
                break;
            default:
                $val = "Nul";
                break;
        }
        return $val;
    }
}



// 
if(!(function_exists('remaindCalculat'))){
    function remaindCalculat($montant, $payer){
        $reste = $montant - collect($payer->payment_scolarities)->sum('amount');
        return preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', $reste);
    }
}



// 
if(!(function_exists('determined'))){
    function determined($montant, $payer){
        $total = collect($payer->payment_scolarities)->sum('amount');
        $val = ($total / $montant) * 100;
        switch (true) {
            case ($val <= 50):
                return 'danger';
                break;
            case ($val <= 70):
                return 'warning';
                break;
            default:
                return 'info';
        }
    }
}


if(!(function_exists('VerifyBox'))){
    function VerifyBox($data, $valeur){
        return count($data) ? ($data[0][$valeur] ? true:false):false;
    }
}


if(!(function_exists('formatMontant'))){
    function formatMontant($amount){
        return $amount ? preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', $amount):null;
    }
}


if(!(function_exists('CalculResteAmount'))){
    function CalculResteAmount($total, $amount){
        $stay = $total - $amount;
        return $stay ? preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', $stay):null;
    }
}


if(!(function_exists('verifyStudentDecoupage'))){
    function verifyStudentDecoupage($type, $decoupage){
        if(in_array($type, ['secondaire','primaire']) && $decoupage == 'trimestre'){
            $val = 'trimestre';
        }
        else{
            $val = 'semestre';
        }
        return $val;
    }
}


if(!(function_exists('typeCenserneCanteen'))){
    function typeCenserneCanteen($primaire, $secondaire, $technique, $superieur){
      return ($primaire ? 'Primaire ':'').($secondaire ? 'Secondaire ':'').($technique ? 'Technique ':'').($superieur ? 'Superieur':'');
    }
}



if(!(function_exists('calculTtlMls'))){
    function calculTtlMls($val = []){
        $total = 0;
        foreach($val as $item){
            $total += is_int((int)$item) ? (int)$item:0;
        }
        return $total <= 9 ? '0'.$total:$total;
    }
}