<?php

namespace App\Http\Controllers;

use App\Models\Verify;
use App\Models\SchoolYear;
use App\Events\GetActifSectionEvent;
use Illuminate\Http\Request;
use Carbon\Carbon;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $this->updateSection();
            
            return view('pages.dashboard');
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    private function updateSection()
    {
        $verif = Verify::where('date', Carbon::now()->toDateString())->first();
        $verif ? null:
        event(new GetActifSectionEvent($this->year(), Carbon::now()->toDateString()));
    }
    

    /**
     * Remove the specified resource from storage.
     */
    private function year(){
        $year = SchoolYear::where('status', '1')->first();
        return $year ? $year['id']:1;
    }
}
