<?php $__env->startSection('title', 'students'); ?>
<?php $__env->startSection('link'); ?>
<link href="<?php echo e(asset('assets/vendor/datatables.net-bs5/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" type="text/css">
<link href="<?php echo e(asset('assets/vendor/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css')); ?>" rel="stylesheet" type="text/css">
<style>
    .dt-search label, .dt-length, .dt-column-order{
        display: none;
    }
    .dt-search input{
        padding: .4rem .77rem;
        border: 1px solid rgb(98, 98, 98);
        border-radius: 5px
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-container">
    <div class="row gx-3">
        <?php echo $__env->make('partials._alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="col-12">
            <div class="card mb-3">
                <div class="card-header border-bottom border-dashed pb-0">
                   <div class="d-flex justify-content-between">
                        <div class="card-title pb-0" style="font-size: 19px;">Gestion Des Apprenants</div>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <a href="<?php echo e(route('student.create')); ?>" type="button" class="btn btn-outline-dark">Add</a>
                            <a href="<?php echo e(route('dashboard')); ?>" type="button" class="btn btn-outline-dark">Back</a>
                        </div>
                   </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive-sm">
                        <table id="myTable"  class="table table-bordered border-dark mb-0"> <!-- id="basic-datatable" -->
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Matricule</th>
                                    <th>Nom</th>
                                    <th>Prenoms</th>
                                    <th>Genre</th>
                                    <th>Date de nais...</th>
                                    <th>Lieu de nais...</th>
                                    
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <!-- <tbody>
                                <?php $i = 1;  ?>
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></td>
                                    <td><?php echo e($student['matricule']); ?></td>
                                    <td><?php echo e(strtoupper($student['first_name'])); ?></td>
                                    <td><?php echo e(ucwords($student['last_name'])); ?></td>
                                    <td><?php echo e($student['sexe'] == 'F' ? 'Feminin':'Masculin'); ?></td>
                                    <td><?php echo e($student['date_birth'] ? date('d/m/Y', strtotime($student['date_birth'])):'A definir'); ?></td>
                                    <td><?php echo e(ucwords($student['birth']) ?? 'A definr'); ?></td>
                                    <td><?php echo e(ucwords($student['residence']) ?? 'A definir'); ?></td>
                                    <td class="text-muted text-center">
                                        <div class="hstack gap-1 justify-content-center">
                                            <a href="<?php echo e(route('student.show', $student['id'])); ?>" class="btn btn-soft-primary btn-icon btn-sm rounded-circle"> <i class="ti ti-eye"></i></a>
                                            <a href="<?php echo e(route('student.edit', $student['id'])); ?>" class="btn btn-soft-success btn-icon btn-sm rounded-circle"> <i class="ti ti-edit fs-16"></i></a>
                                            <a href="javascript:void(0);" class="btn btn-soft-danger btn-icon btn-sm rounded-circle"> <i class="ti ti-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody> -->
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: '<?php echo e(route('student.data')); ?>',
            columns: [
                {data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
                {data: 'matricule', name: 'matricule'},
                {data: 'first_name', name: 'first_name'},
                {data: 'last_name', name: 'last_name'},
                {data: ('sexe'), name: 'sexe'},
                {data: 'date_birth', name: 'date_birth'},
                {data: 'birth', name: 'birth'},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ],
            pageLength: 10,
            language: {
                url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
            }
        });
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/educasnsa/public_html/Centre_thalith/resources/views/pages/students/index.blade.php ENDPATH**/ ?>