
<?php $__env->startSection('title', 'Appel'); ?>
<?php $__env->startSection('link'); ?>
<link href="<?php echo e(asset('assets/vendor/datatables.net-bs5/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" type="text/css">
<link href="<?php echo e(asset('assets/vendor/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css')); ?>" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/alertify.min.css"/>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/themes/default.min.css"/>
<style>
    .dt-length{
        display: none;
    }
    .dt-search input{
        padding: .4rem .77rem;
        border: 1px solid rgb(98, 98, 98);
        border-radius: 5px
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-container">
    <div class="row">
        <?php echo $__env->make('partials._alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom border-dashed pb-0">
                   <div class="d-flex justify-content-between mb-0 pb-0">
                      <div class="card-title pb-0" style="font-size: 19px;">Appel Du <strong style="text-decoration: underline"><?php echo e(ucwords($date)); ?></strong></div>
                      <div class="card-title pb-0" style="font-size: 19px;">Groupe <?php echo e(ucfirst($group)); ?></div>
                      <div class="group-btn py-0" role="group" aria-label="Basic example">
                          
                          <a href="<?php echo e(route('appel.index')); ?>" type="button" class="btn btn-soft-dark bg-gradient py-0">Back</a>
                          <input type="hidden" id="appel" value="<?php echo e($appel->id); ?>">
                      </div>
                   </div>
                </div>
                <div class="card-body">
                    <table id="basic-datatable" class="table table-striped table-bordered border-dark dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th style="width: 5%"></th>
                                <th class="text-center" style="width: 10%">Matricule</th>
                                <th class="text-center" style="width: 15%">Nom</th>
                                <th class="text-center">Prenoms</th>
                                <th class="text-center" style="width: 15%">Genre</th>
                                <th class="text-center" style="width: 15%">Niveau</th>
                                <th class="text-center" style="width: 15%">Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $i = 0; ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center pt-2"><?php echo e($i <= 9 ? '0'.++$i : ++$i); ?></td>
                                    <td class="text-center pt-2"><?php echo e($item->matricule); ?></td>
                                    <td><?php echo e(strtoupper($item->first_name)); ?></td>
                                    <td><?php echo e(ucwords($item->last_name)); ?></td>
                                    <td class="text-center pt-2"><?php echo e(ucwords($item->sexe == 'F' ? 'Feminin':'Masculin')); ?></td>
                                    <td class="text-center pt-2"><?php echo e($item->code); ?></td>
                                    <td class="text-center">
                                        <div class="hstack gap-1 justify-content-center">
                                            <input type="checkbox" class="checkbox" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/vendor/datatables.net/js/dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/datatables.net-bs5/js/dataTables.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/components/table-datatable.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/alertify.min.js"></script>
<script>
  $(document).ready(function() {
    $('.form-control').attr('placeholder', 'Search...');


    // On click Input Checkbox
    $(document).on('click', '.checkbox', function() {
        $checked = $(this).is(':checked') ? 1:0;
        $.ajax({
            url: "<?php echo e(route('appel.store')); ?>",
            type: "GET",
            data: {
                student: $(this).val(),
                appel: $('#appel').val(),
                val: $checked
            },
            success: function (data) {
                if(data == 200){
                    alertify.set('notifier','position', 'top-right');
                    $checked ? 
                    alertify.success('<i class="ri-calendar-check-line mr2"></i> Absence pointée.'):
                    alertify.success('<i class="ri-calendar-close-fill mr-2"></i> Absence annulée.');
                }
                else{
                    alertify.set('notifier','position', 'top-right');
                    alertify.error('Une erreur est survenue.');
                }
            }
        });
    });

})
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\THALITH\resources\views\pages\appels\create.blade.php ENDPATH**/ ?>